/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.tools.metadata.services;

import com.example.vibe.core.logging.VibeLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MdoXmlService {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(MdoXmlService.class);
    private static MdoXmlService instance;
    private final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private final TransformerFactory transformerFactory;
    private final XPathFactory xPathFactory;

    private MdoXmlService() {
        this.docBuilderFactory.setNamespaceAware(true);
        this.transformerFactory = TransformerFactory.newInstance();
        this.xPathFactory = XPathFactory.newInstance();
    }

    public static synchronized MdoXmlService getInstance() {
        if (instance == null) {
            instance = new MdoXmlService();
        }
        return instance;
    }

    public String generateUuid() {
        return UUID.randomUUID().toString();
    }

    public Document parseMdo(IFile mdoFile) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = mdoFile.getContents();){
                DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
                return builder.parse(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 MDO \u0444\u0430\u0439\u043b\u0430 %s: %s", mdoFile.getFullPath(), e.getMessage());
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 MDO: " + e.getMessage(), e);
        }
    }

    public Document parseXml(String xml) {
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 XML: %s", e.getMessage());
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 XML: " + e.getMessage(), e);
        }
    }

    public String getMdoContent(IFile mdoFile) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = mdoFile.getContents();){
                return new String(is.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f MDO \u0444\u0430\u0439\u043b\u0430 %s: %s", mdoFile.getFullPath(), e.getMessage());
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f MDO: " + e.getMessage(), e);
        }
    }

    public void writeMdo(IFile mdoFile, Document doc) throws CoreException {
        String content = this.serializeXml(doc);
        this.writeMdo(mdoFile, content);
    }

    public void writeMdo(IFile mdoFile, String content) throws CoreException {
        LOG.debug("[MDO_XML] writeMdo: \u043d\u0430\u0447\u0430\u043b\u043e \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 %s", mdoFile.getFullPath());
        LOG.debug("[MDO_XML] writeMdo: \u043f\u0443\u0442\u044c \u043d\u0430 \u0434\u0438\u0441\u043a\u0435: %s", mdoFile.getLocation());
        LOG.debug("[MDO_XML] writeMdo: \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u043e\u043d\u0442\u0435\u043d\u0442\u0430: %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", content.length());
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream source = new ByteArrayInputStream(bytes);
        if (mdoFile.exists()) {
            LOG.debug("[MDO_XML] writeMdo: \u0444\u0430\u0439\u043b \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435");
            mdoFile.setContents((InputStream)source, 3, (IProgressMonitor)new NullProgressMonitor());
            LOG.info("[MDO_XML] \u2713 \u0424\u0430\u0439\u043b \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d: %s (%d \u0431\u0430\u0439\u0442)", mdoFile.getFullPath(), bytes.length);
        } else {
            LOG.debug("[MDO_XML] writeMdo: \u0444\u0430\u0439\u043b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u0441\u043e\u0437\u0434\u0430\u0451\u043c \u043d\u043e\u0432\u044b\u0439");
            this.ensureParentExists(mdoFile);
            mdoFile.create((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
            LOG.info("[MDO_XML] \u2713 \u0424\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d: %s (%d \u0431\u0430\u0439\u0442)", mdoFile.getFullPath(), bytes.length);
        }
        mdoFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        LOG.debug("[MDO_XML] writeMdo: refreshLocal \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
    }

    public String serializeXml(Document doc) {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            LOG.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 XML: %s", e.getMessage());
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 XML: " + e.getMessage(), e);
        }
    }

    public Element findElement(Document doc, String xpath) {
        try {
            XPath xp = this.xPathFactory.newXPath();
            return (Element)xp.evaluate(xpath, doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            LOG.warn("\u041e\u0448\u0438\u0431\u043a\u0430 XPath '%s': %s", xpath, e.getMessage());
            return null;
        }
    }

    public NodeList findElements(Document doc, String xpath) {
        try {
            XPath xp = this.xPathFactory.newXPath();
            return (NodeList)xp.evaluate(xpath, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            LOG.warn("\u041e\u0448\u0438\u0431\u043a\u0430 XPath '%s': %s", xpath, e.getMessage());
            return null;
        }
    }

    public void insertElement(Document doc, String parentXPath, Element element) {
        Element parent = this.findElement(doc, parentXPath);
        if (parent != null) {
            Node imported = doc.importNode(element, true);
            parent.appendChild(imported);
        } else {
            LOG.warn("\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", parentXPath);
        }
    }

    public void insertAfter(Document doc, String siblingXPath, String xmlFragment) {
        Element sibling = this.findElement(doc, siblingXPath);
        if (sibling != null && sibling.getParentNode() != null) {
            Document fragDoc = this.parseXml("<root>" + xmlFragment + "</root>");
            NodeList children = fragDoc.getDocumentElement().getChildNodes();
            Node parent = sibling.getParentNode();
            Node nextSibling = sibling.getNextSibling();
            int i = 0;
            while (i < children.getLength()) {
                Node imported = doc.importNode(children.item(i), true);
                if (nextSibling != null) {
                    parent.insertBefore(imported, nextSibling);
                } else {
                    parent.appendChild(imported);
                }
                ++i;
            }
        } else {
            LOG.warn("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", siblingXPath);
        }
    }

    public void insertBefore(Document doc, String siblingXPath, String xmlFragment) {
        Element sibling = this.findElement(doc, siblingXPath);
        if (sibling != null && sibling.getParentNode() != null) {
            Document fragDoc = this.parseXml("<root>" + xmlFragment + "</root>");
            NodeList children = fragDoc.getDocumentElement().getChildNodes();
            Node parent = sibling.getParentNode();
            int i = 0;
            while (i < children.getLength()) {
                Node imported = doc.importNode(children.item(i), true);
                parent.insertBefore(imported, sibling);
                ++i;
            }
        } else {
            LOG.warn("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", siblingXPath);
        }
    }

    public void appendToParent(Document doc, String parentXPath, String xmlFragment) {
        Element parent = this.findElement(doc, parentXPath);
        if (parent != null) {
            Document fragDoc = this.parseXml("<root>" + xmlFragment + "</root>");
            NodeList children = fragDoc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node imported = doc.importNode(children.item(i), true);
                parent.appendChild(imported);
                ++i;
            }
        } else {
            LOG.warn("\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: %s", parentXPath);
        }
    }

    public IFolder createObjectFolder(IProject project, String folderPath) throws CoreException {
        IFolder folder = project.getFolder(folderPath);
        if (!folder.exists()) {
            this.ensureFolderExists(folder);
        }
        return folder;
    }

    private void ensureFolderExists(IFolder folder) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            this.ensureFolderExists((IFolder)parent);
        }
        folder.create(1, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void ensureParentExists(IFile file) throws CoreException {
        IContainer parent = file.getParent();
        if (parent instanceof IFolder) {
            this.ensureFolderExists((IFolder)parent);
        }
    }

    public boolean fileExists(IProject project, String path) {
        IFile file = project.getFile(path);
        return file.exists();
    }

    public IFile getFile(IProject project, String path) {
        return project.getFile(path);
    }
}

