/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.util;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class CancellationToken {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final List<Runnable> callbacks = new CopyOnWriteArrayList<Runnable>();

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            for (Runnable callback : this.callbacks) {
                try {
                    callback.run();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void throwIfCancelled() throws CancellationException {
        if (this.cancelled.get()) {
            throw new CancellationException("Operation was cancelled");
        }
    }

    public void onCancel(Runnable callback) {
        if (callback == null) {
            return;
        }
        this.callbacks.add(callback);
        if (this.cancelled.get()) {
            try {
                callback.run();
            }
            catch (Exception exception) {}
        }
    }

    public boolean removeCallback(Runnable callback) {
        return this.callbacks.remove(callback);
    }

    public CancellationToken createLinkedToken() {
        CancellationToken linked = new CancellationToken();
        if (this.isCancelled()) {
            linked.cancel();
        } else {
            this.onCancel(linked::cancel);
        }
        return linked;
    }

    public static CancellationToken cancelled() {
        CancellationToken token = new CancellationToken();
        token.cancel();
        return token;
    }

    public static CancellationToken none() {
        return new CancellationToken(){

            @Override
            public void cancel() {
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
    }
}

