/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.chat;

import com.example.vibe.core.agent.AgentState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class AgentProgressWidget
extends Composite {
    private ProgressBar progressBar;
    private Label statusLabel;
    private Label stateLabel;
    private Label stepLabel;

    public AgentProgressWidget(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    private void createContents() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 8;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 8;
        this.setLayout((Layout)layout);
        this.stateLabel = new Label((Composite)this, 0);
        this.stateLabel.setText("\u25ef \u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435");
        this.stateLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.stepLabel = new Label((Composite)this, 0);
        this.stepLabel.setText("");
        this.stepLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.progressBar = new ProgressBar((Composite)this, 65792);
        GridData progressData = new GridData(4, 0x1000000, true, false);
        progressData.horizontalSpan = 2;
        this.progressBar.setLayoutData((Object)progressData);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        this.statusLabel = new Label((Composite)this, 64);
        GridData statusData = new GridData(4, 0x1000000, true, false);
        statusData.horizontalSpan = 2;
        this.statusLabel.setLayoutData((Object)statusData);
        this.statusLabel.setText("");
        this.setVisible(false);
        GridData myData = new GridData(4, 0x1000000, true, false);
        myData.exclude = true;
        this.setLayoutData(myData);
    }

    public void updateProgress(int current, int max, String status) {
        if (this.isDisposed()) {
            return;
        }
        int percentage = max > 0 ? current * 100 / max : 0;
        this.progressBar.setSelection(percentage);
        this.stepLabel.setText(String.format("\u0428\u0430\u0433 %d/%d", current, max));
        if (status != null) {
            this.statusLabel.setText(status);
        }
        this.showWidget();
    }

    public void updateState(AgentState state, String errorMessage) {
        String stateText;
        if (this.isDisposed()) {
            return;
        }
        switch (state) {
            case IDLE: {
                String stateText2 = "\u25ef \u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435";
                this.hideWidget();
                return;
            }
            case RUNNING: {
                stateText = "\u25b6 \u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435";
                break;
            }
            case WAITING_TOOL: {
                stateText = "\ud83d\udd27 \u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442";
                break;
            }
            case WAITING_CONFIRMATION: {
                stateText = "\u23f8 \u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435";
                break;
            }
            case COMPLETED: {
                stateText = "\u2713 \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
                break;
            }
            case CANCELLED: {
                stateText = "\u2298 \u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e";
                break;
            }
            case ERROR: {
                stateText = "\u2717 \u041e\u0448\u0438\u0431\u043a\u0430";
                if (errorMessage == null) break;
                this.statusLabel.setText(errorMessage);
                break;
            }
            default: {
                stateText = state.toString();
            }
        }
        this.stateLabel.setText(stateText);
        this.showWidget();
        if (state == AgentState.COMPLETED || state == AgentState.CANCELLED) {
            this.getDisplay().timerExec(3000, () -> {
                if (!this.isDisposed() && (this.stateLabel.getText().equals("\u2713 \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e") || this.stateLabel.getText().equals("\u2298 \u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e"))) {
                    this.hideWidget();
                }
            });
        }
    }

    public void setIndeterminate(boolean indeterminate) {
    }

    public void reset() {
        if (this.isDisposed()) {
            return;
        }
        this.progressBar.setSelection(0);
        this.stateLabel.setText("\u25ef \u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435");
        this.stepLabel.setText("");
        this.statusLabel.setText("");
        this.hideWidget();
    }

    private void showWidget() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.getVisible()) {
            this.setVisible(true);
            GridData data = (GridData)this.getLayoutData();
            if (data != null) {
                data.exclude = false;
            }
            this.getParent().layout(true, true);
        }
    }

    private void hideWidget() {
        if (this.isDisposed()) {
            return;
        }
        if (this.getVisible()) {
            this.setVisible(false);
            GridData data = (GridData)this.getLayoutData();
            if (data != null) {
                data.exclude = true;
            }
            this.getParent().layout(true, true);
        }
    }
}

