/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.chat;

import com.example.vibe.core.agent.AgentConfig;
import com.example.vibe.core.agent.AgentResult;
import com.example.vibe.core.agent.AgentRunner;
import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.events.AgentCompletedEvent;
import com.example.vibe.core.agent.events.AgentEvent;
import com.example.vibe.core.agent.events.AgentStartedEvent;
import com.example.vibe.core.agent.events.AgentStepEvent;
import com.example.vibe.core.agent.events.ConfirmationRequiredEvent;
import com.example.vibe.core.agent.events.IAgentEventListener;
import com.example.vibe.core.agent.events.StreamChunkEvent;
import com.example.vibe.core.agent.events.ToolCallEvent;
import com.example.vibe.core.agent.events.ToolResultEvent;
import com.example.vibe.core.agent.profiles.AgentProfile;
import com.example.vibe.core.agent.profiles.AgentProfileRegistry;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.provider.LlmProviderRegistry;
import com.example.vibe.core.tools.ToolRegistry;
import com.example.vibe.ui.dialogs.ToolConfirmationDialog;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.swt.widgets.Display;

public class AgentViewAdapter
implements IAgentEventListener {
    private final Display display;
    private AgentRunner currentRunner;
    private StringBuilder streamingContent;
    private String currentStreamingMessageId;
    private MessageAppender messageAppender;
    private ProgressUpdater progressUpdater;
    private StateChangeListener stateChangeListener;
    private ConfirmationHandler confirmationHandler;

    public AgentViewAdapter(Display display) {
        this.display = Objects.requireNonNull(display, "display");
    }

    public void setMessageAppender(MessageAppender appender) {
        this.messageAppender = appender;
    }

    public void setProgressUpdater(ProgressUpdater updater) {
        this.progressUpdater = updater;
    }

    public void setStateChangeListener(StateChangeListener listener) {
        this.stateChangeListener = listener;
    }

    public void setConfirmationHandler(ConfirmationHandler handler) {
        this.confirmationHandler = handler;
    }

    public CompletableFuture<AgentResult> run(String prompt, String profileId) {
        ILlmProvider provider = LlmProviderRegistry.getInstance().getActiveProvider();
        if (provider == null || !provider.isConfigured()) {
            return CompletableFuture.failedFuture(new IllegalStateException("LLM \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d"));
        }
        AgentProfile profile = AgentProfileRegistry.getInstance().getProfile(profileId).orElse(AgentProfileRegistry.getInstance().getDefaultProfile());
        AgentConfig config = AgentProfileRegistry.getInstance().createConfig(profile);
        this.currentRunner = new AgentRunner(provider, ToolRegistry.getInstance(), profile.getSystemPromptAddition());
        this.currentRunner.addListener((IAgentEventListener)this);
        this.streamingContent = new StringBuilder();
        this.currentStreamingMessageId = null;
        return this.currentRunner.run(prompt, config).whenComplete((result, error) -> {
            this.currentRunner.removeListener((IAgentEventListener)this);
            if (error != null && this.stateChangeListener != null) {
                this.asyncExec(() -> this.stateChangeListener.onStateChange(AgentState.ERROR, error.getMessage()));
            }
        });
    }

    public void cancel() {
        if (this.currentRunner != null) {
            this.currentRunner.cancel();
        }
    }

    public AgentState getState() {
        return this.currentRunner != null ? this.currentRunner.getState() : AgentState.IDLE;
    }

    public boolean isRunning() {
        AgentState state = this.getState();
        return state == AgentState.RUNNING || state == AgentState.WAITING_TOOL || state == AgentState.WAITING_CONFIRMATION;
    }

    public void onEvent(AgentEvent event) {
        switch (event.getType()) {
            case STARTED: {
                this.handleStarted((AgentStartedEvent)event);
                break;
            }
            case STEP: {
                this.handleStep((AgentStepEvent)event);
                break;
            }
            case TOOL_CALL: {
                this.handleToolCall((ToolCallEvent)event);
                break;
            }
            case TOOL_RESULT: {
                this.handleToolResult((ToolResultEvent)event);
                break;
            }
            case STREAM_CHUNK: {
                this.handleStreamChunk((StreamChunkEvent)event);
                break;
            }
            case CONFIRMATION_REQUIRED: {
                this.handleConfirmation((ConfirmationRequiredEvent)event);
                break;
            }
            case COMPLETED: {
                this.handleCompleted((AgentCompletedEvent)event);
                break;
            }
        }
    }

    private void handleStarted(AgentStartedEvent event) {
        this.asyncExec(() -> {
            if (this.stateChangeListener != null) {
                this.stateChangeListener.onStateChange(AgentState.RUNNING, null);
            }
            if (this.messageAppender != null) {
                String info = String.format("\ud83d\ude80 \u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d (\u043f\u0440\u043e\u0444\u0438\u043b\u044c: %s, \u043c\u0430\u043a\u0441. \u0448\u0430\u0433\u043e\u0432: %d)", event.getConfig().getProfileName() != null ? event.getConfig().getProfileName() : "default", event.getConfig().getMaxSteps());
                this.messageAppender.appendSystemMessage(info);
            }
        });
    }

    private void handleStep(AgentStepEvent event) {
        this.asyncExec(() -> {
            if (this.progressUpdater != null) {
                String status = String.format("\u0428\u0430\u0433 %d/%d: %s", event.getStep(), event.getMaxSteps(), event.getDescription());
                this.progressUpdater.updateProgress(event.getStep(), event.getMaxSteps(), status);
            }
        });
    }

    private void handleToolCall(ToolCallEvent event) {
        this.asyncExec(() -> {
            if (this.messageAppender != null) {
                String icon = event.isRequiresConfirmation() ? "\u26a0\ufe0f" : "\ud83d\udd27";
                String info = String.format("%s \u0412\u044b\u0437\u043e\u0432 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0430: %s", icon, event.getToolName());
                this.messageAppender.appendSystemMessage(info);
            }
        });
    }

    private void handleToolResult(ToolResultEvent event) {
        this.asyncExec(() -> {
            if (this.messageAppender != null) {
                Object content;
                String icon = event.getResult().isSuccess() ? "\u2713" : "\u2717";
                Object object = content = event.getResult().isSuccess() ? event.getResult().getContent() : event.getResult().getErrorMessage();
                if (content != null && ((String)content).length() > 500) {
                    content = ((String)content).substring(0, 500) + "\n... (\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e)";
                }
                String info = String.format("%s **%s** (%d \u043c\u0441)\n%s", icon, this.getToolDisplayName(event.getToolName()), event.getExecutionTimeMs(), content != null ? content : "");
                this.messageAppender.appendToolMessage(info);
            }
        });
    }

    private void handleStreamChunk(StreamChunkEvent event) {
        if (!event.isComplete() && event.getContent() != null) {
            this.streamingContent.append(event.getContent());
            this.asyncExec(() -> {
                if (this.messageAppender != null) {
                    this.messageAppender.updateStreamingMessage(this.currentStreamingMessageId, this.streamingContent.toString());
                }
            });
        } else if (event.isComplete()) {
            String finalContent = this.streamingContent.toString();
            this.streamingContent = new StringBuilder();
            this.currentStreamingMessageId = null;
            this.asyncExec(() -> {
                if (this.messageAppender != null && !finalContent.isEmpty()) {
                    this.messageAppender.appendAssistantMessage(finalContent);
                }
            });
        }
    }

    private void handleConfirmation(ConfirmationRequiredEvent event) {
        this.asyncExec(() -> {
            if (this.confirmationHandler != null) {
                this.confirmationHandler.requestConfirmation(event);
            } else {
                this.showConfirmationDialog(event);
            }
        });
    }

    private void showConfirmationDialog(ConfirmationRequiredEvent event) {
        if (this.display.isDisposed()) {
            event.deny();
            return;
        }
        ToolConfirmationDialog dialog = new ToolConfirmationDialog(this.display.getActiveShell(), event.getToolCall(), event.getToolDescription(), event.isDestructive());
        if (dialog.openAndConfirm()) {
            event.confirm();
        } else if (dialog.wasSkipped()) {
            event.skip();
        } else {
            event.deny();
        }
    }

    private void handleCompleted(AgentCompletedEvent event) {
        AgentResult result = event.getResult();
        this.asyncExec(() -> {
            if (this.stateChangeListener != null) {
                this.stateChangeListener.onStateChange(result.getFinalState(), result.getErrorMessage());
            }
            if (this.messageAppender != null) {
                this.messageAppender.appendSystemMessage((String)(switch (result.getFinalState()) {
                    case AgentState.COMPLETED -> String.format("\u2705 \u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d (\u0448\u0430\u0433\u043e\u0432: %d, \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432: %d, \u0432\u0440\u0435\u043c\u044f: %d \u043c\u0441)", result.getStepsExecuted(), result.getToolCallsExecuted(), result.getExecutionTimeMs());
                    case AgentState.CANCELLED -> "\u2298 \u0410\u0433\u0435\u043d\u0442 \u043e\u0442\u043c\u0435\u043d\u0451\u043d";
                    case AgentState.ERROR -> "\u274c \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0433\u0435\u043d\u0442\u0430: " + result.getErrorMessage();
                    default -> "\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d: " + String.valueOf(result.getFinalState());
                }));
                if (result.isSuccess() && result.getFinalResponse() != null && !result.getFinalResponse().isEmpty()) {
                    this.messageAppender.appendAssistantMessage(result.getFinalResponse());
                }
            }
        });
    }

    private String getToolDisplayName(String name) {
        return switch (name) {
            case "read_file" -> "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "edit_file" -> "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "write_file" -> "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "list_files" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
            case "glob" -> "\u041f\u043e\u0438\u0441\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
            case "grep" -> "\u041f\u043e\u0438\u0441\u043a \u0442\u0435\u043a\u0441\u0442\u0430";
            case "shell" -> "\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0438";
            case "search_codebase" -> "\u0421\u0435\u043c\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u043e\u0438\u0441\u043a";
            case "task" -> "\u041f\u043e\u0434\u0437\u0430\u0434\u0430\u0447\u0430";
            default -> name;
        };
    }

    private void asyncExec(Runnable runnable) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(() -> {
                if (!this.display.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    public void dispose() {
        this.cancel();
        if (this.currentRunner != null) {
            this.currentRunner.dispose();
            this.currentRunner = null;
        }
    }

    public static interface ConfirmationHandler {
        public void requestConfirmation(ConfirmationRequiredEvent var1);
    }

    public static interface MessageAppender {
        public void appendSystemMessage(String var1);

        public void appendAssistantMessage(String var1);

        public void appendToolMessage(String var1);

        public void updateStreamingMessage(String var1, String var2);
    }

    public static interface ProgressUpdater {
        public void updateProgress(int var1, int var2, String var3);
    }

    public static interface StateChangeListener {
        public void onStateChange(AgentState var1, String var2);
    }
}

