/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.chat;

import com.example.vibe.core.model.LlmMessage;
import com.example.vibe.core.model.ToolCall;
import com.example.vibe.ui.chat.MessageKind;
import com.example.vibe.ui.chat.MessagePart;
import com.example.vibe.ui.chat.MessageStatus;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ChatMessage {
    private final String id;
    private final MessageKind kind;
    private final Instant timestamp;
    private MessageStatus status;
    private String rawContent;
    private final List<MessagePart> parts;
    private String errorMessage;
    private final List<ToolCall> toolCalls;
    private String supersededById;
    private String regeneratedFromId;

    public ChatMessage(MessageKind kind, String rawContent) {
        this(UUID.randomUUID().toString(), kind, rawContent, Instant.now(), MessageStatus.COMPLETE);
    }

    public ChatMessage(String id, MessageKind kind, String rawContent, Instant timestamp, MessageStatus status) {
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.kind = Objects.requireNonNull(kind, "kind must not be null");
        this.rawContent = rawContent != null ? rawContent : "";
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
        this.status = Objects.requireNonNull(status, "status must not be null");
        this.parts = new ArrayList<MessagePart>();
        this.toolCalls = new ArrayList<ToolCall>();
    }

    public static ChatMessage user(String content) {
        return new ChatMessage(MessageKind.USER, content);
    }

    public static ChatMessage assistant(String content) {
        return new ChatMessage(MessageKind.ASSISTANT, content);
    }

    public static ChatMessage pendingAssistant() {
        return new ChatMessage(UUID.randomUUID().toString(), MessageKind.ASSISTANT, "", Instant.now(), MessageStatus.PENDING);
    }

    public static ChatMessage system(String content) {
        return new ChatMessage(MessageKind.SYSTEM, content);
    }

    public static ChatMessage toolCall(List<ToolCall> toolCalls) {
        ChatMessage message = new ChatMessage(MessageKind.TOOL_CALL, null);
        message.toolCalls.addAll(toolCalls);
        return message;
    }

    public static ChatMessage toolResult(String toolCallId, String toolName, String content, boolean success) {
        ChatMessage message = new ChatMessage(MessageKind.TOOL_RESULT, content);
        message.parts.add(new MessagePart.ToolResultPart(toolCallId, toolName, content, success, MessagePart.ToolResultPart.ResultType.TEXT));
        return message;
    }

    public static ChatMessage fromLlmMessage(LlmMessage llmMessage) {
        MessageKind kind = switch (llmMessage.getRole()) {
            case LlmMessage.Role.USER -> MessageKind.USER;
            case LlmMessage.Role.ASSISTANT -> {
                if (llmMessage.hasToolCalls()) {
                    yield MessageKind.TOOL_CALL;
                }
                yield MessageKind.ASSISTANT;
            }
            case LlmMessage.Role.SYSTEM -> MessageKind.SYSTEM;
            case LlmMessage.Role.TOOL -> MessageKind.TOOL_RESULT;
            default -> throw new IncompatibleClassChangeError();
        };
        ChatMessage message = new ChatMessage(kind, llmMessage.getContent());
        if (llmMessage.hasToolCalls()) {
            message.toolCalls.addAll(llmMessage.getToolCalls());
        }
        return message;
    }

    public String getId() {
        return this.id;
    }

    public MessageKind getKind() {
        return this.kind;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public MessageStatus getStatus() {
        return this.status;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public List<MessagePart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public List<ToolCall> getToolCalls() {
        return Collections.unmodifiableList(this.toolCalls);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSupersededById() {
        return this.supersededById;
    }

    public String getRegeneratedFromId() {
        return this.regeneratedFromId;
    }

    public boolean isPending() {
        return this.status == MessageStatus.PENDING;
    }

    public boolean isComplete() {
        return this.status == MessageStatus.COMPLETE;
    }

    public boolean isFailed() {
        return this.status == MessageStatus.FAILED;
    }

    public boolean isSuperseded() {
        return this.status == MessageStatus.SUPERSEDED;
    }

    public boolean hasToolCalls() {
        return !this.toolCalls.isEmpty();
    }

    public void setStatus(MessageStatus status) {
        this.status = Objects.requireNonNull(status);
    }

    public void appendContent(String chunk) {
        if (chunk != null && !chunk.isEmpty()) {
            this.rawContent = this.rawContent + chunk;
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void markSupersededBy(String newMessageId) {
        this.supersededById = newMessageId;
        this.status = MessageStatus.SUPERSEDED;
    }

    public void markRegeneratedFrom(String originalMessageId) {
        this.regeneratedFromId = originalMessageId;
    }

    public void setParts(List<MessagePart> parts) {
        this.parts.clear();
        if (parts != null) {
            this.parts.addAll(parts);
        }
    }

    public void addPart(MessagePart part) {
        if (part != null) {
            this.parts.add(part);
        }
    }

    public LlmMessage toLlmMessage() {
        return switch (this.kind) {
            case MessageKind.USER -> LlmMessage.user((String)this.rawContent);
            case MessageKind.ASSISTANT -> {
                if (this.hasToolCalls()) {
                    yield LlmMessage.assistantWithToolCalls((String)this.rawContent, this.toolCalls);
                }
                yield LlmMessage.assistant((String)this.rawContent);
            }
            case MessageKind.SYSTEM -> LlmMessage.system((String)this.rawContent);
            case MessageKind.TOOL_CALL -> LlmMessage.assistantWithToolCalls((String)this.rawContent, this.toolCalls);
            case MessageKind.TOOL_RESULT -> {
                String toolCallId = this.parts.stream().filter(p -> p instanceof MessagePart.ToolResultPart).map(p -> ((MessagePart.ToolResultPart)p).toolCallId()).findFirst().orElse("unknown");
                yield LlmMessage.toolResult((String)toolCallId, (String)this.rawContent);
            }
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public String toString() {
        return String.format("ChatMessage[id=%s, kind=%s, status=%s]", new Object[]{this.id, this.kind, this.status});
    }
}

