/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.chat;

import com.example.vibe.ui.chat.MessagePart;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageContentParser {
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("```(\\w*)\\n([\\s\\S]*?)```", 8);
    private static final Pattern TODO_ITEM_PATTERN = Pattern.compile("^[\\s]*[-*]\\s*\\[([ xX])\\]\\s*(.+)$", 8);
    private static final Pattern HAS_TODO_PATTERN = Pattern.compile("[-*]\\s*\\[[ xX]\\]");

    public List<MessagePart> parse(String rawContent) {
        if (rawContent == null || rawContent.isEmpty()) {
            return List.of();
        }
        ArrayList<MessagePart> parts = new ArrayList<MessagePart>();
        List<CodeBlockInfo> codeBlocks = this.extractCodeBlocks(rawContent);
        if (codeBlocks.isEmpty()) {
            this.parseTextOrTodo(rawContent, parts);
        } else {
            String textAfter;
            int lastEnd = 0;
            for (CodeBlockInfo block : codeBlocks) {
                String textBefore;
                if (block.start > lastEnd && !(textBefore = rawContent.substring(lastEnd, block.start)).trim().isEmpty()) {
                    this.parseTextOrTodo(textBefore, parts);
                }
                parts.add(new MessagePart.CodeBlockPart(block.code.trim(), block.language));
                lastEnd = block.end;
            }
            if (lastEnd < rawContent.length() && !(textAfter = rawContent.substring(lastEnd)).trim().isEmpty()) {
                this.parseTextOrTodo(textAfter, parts);
            }
        }
        return parts;
    }

    private List<CodeBlockInfo> extractCodeBlocks(String content) {
        ArrayList<CodeBlockInfo> blocks = new ArrayList<CodeBlockInfo>();
        Matcher matcher = CODE_BLOCK_PATTERN.matcher(content);
        while (matcher.find()) {
            blocks.add(new CodeBlockInfo(matcher.start(), matcher.end(), matcher.group(1), matcher.group(2)));
        }
        return blocks;
    }

    private void parseTextOrTodo(String text, List<MessagePart> parts) {
        if (!HAS_TODO_PATTERN.matcher(text).find()) {
            parts.add(new MessagePart.TextPart(text.trim()));
            return;
        }
        this.parseTodoList(text, parts);
    }

    private void parseTodoList(String text, List<MessagePart> parts) {
        String remainingText;
        String[] lines = text.split("\\n");
        StringBuilder textBuffer = new StringBuilder();
        ArrayList<MessagePart.TodoListPart.TodoItem> todoItems = new ArrayList<MessagePart.TodoListPart.TodoItem>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher todoMatcher = TODO_ITEM_PATTERN.matcher(line);
            if (todoMatcher.matches()) {
                if (textBuffer.length() > 0 && todoItems.isEmpty()) {
                    String bufferedText = textBuffer.toString().trim();
                    if (!bufferedText.isEmpty()) {
                        parts.add(new MessagePart.TextPart(bufferedText));
                    }
                    textBuffer.setLength(0);
                }
                boolean checked = !todoMatcher.group(1).trim().isEmpty();
                String itemText = todoMatcher.group(2).trim();
                todoItems.add(new MessagePart.TodoListPart.TodoItem(itemText, checked));
            } else {
                if (!todoItems.isEmpty()) {
                    parts.add(new MessagePart.TodoListPart(new ArrayList<MessagePart.TodoListPart.TodoItem>(todoItems)));
                    todoItems.clear();
                }
                if (textBuffer.length() > 0) {
                    textBuffer.append("\n");
                }
                textBuffer.append(line);
            }
            ++n2;
        }
        if (!todoItems.isEmpty()) {
            parts.add(new MessagePart.TodoListPart(new ArrayList<MessagePart.TodoListPart.TodoItem>(todoItems)));
        }
        if (textBuffer.length() > 0 && !(remainingText = textBuffer.toString().trim()).isEmpty()) {
            parts.add(new MessagePart.TextPart(remainingText));
        }
    }

    public List<MessagePart.CodeBlockPart> extractCodeBlockParts(String content) {
        ArrayList<MessagePart.CodeBlockPart> blocks = new ArrayList<MessagePart.CodeBlockPart>();
        Matcher matcher = CODE_BLOCK_PATTERN.matcher(content);
        while (matcher.find()) {
            blocks.add(new MessagePart.CodeBlockPart(matcher.group(2).trim(), matcher.group(1)));
        }
        return blocks;
    }

    public boolean hasCodeBlocks(String content) {
        if (content == null) {
            return false;
        }
        return CODE_BLOCK_PATTERN.matcher(content).find();
    }

    public boolean hasTodoItems(String content) {
        if (content == null) {
            return false;
        }
        return HAS_TODO_PATTERN.matcher(content).find();
    }

    private static class CodeBlockInfo {
        final int start;
        final int end;
        final String language;
        final String code;

        CodeBlockInfo(int start, int end, String language, String code) {
            this.start = start;
            this.end = end;
            this.language = language;
            this.code = code;
        }
    }
}

