/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.chat;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MessagePart {
    public PartType getType();

    public record CodeBlockPart(String code, String language) implements MessagePart
    {
        public CodeBlockPart {
            Objects.requireNonNull(code, "code must not be null");
        }

        public CodeBlockPart(String code) {
            this(code, null);
        }

        @Override
        public PartType getType() {
            return PartType.CODE_BLOCK;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }
    }

    public static enum PartType {
        TEXT,
        CODE_BLOCK,
        TOOL_CALL,
        TOOL_RESULT,
        TODO_LIST;

    }

    public record TextPart(String content) implements MessagePart
    {
        public TextPart {
            Objects.requireNonNull(content, "content must not be null");
        }

        @Override
        public PartType getType() {
            return PartType.TEXT;
        }
    }

    public record TodoListPart(List<TodoItem> items) implements MessagePart
    {
        public TodoListPart {
            Objects.requireNonNull(items, "items must not be null");
        }

        @Override
        public PartType getType() {
            return PartType.TODO_LIST;
        }

        public int completedCount() {
            return (int)this.items.stream().filter(TodoItem::checked).count();
        }

        public int completionPercent() {
            if (this.items.isEmpty()) {
                return 0;
            }
            return this.completedCount() * 100 / this.items.size();
        }

        public record TodoItem(String text, boolean checked) {
            public TodoItem {
                Objects.requireNonNull(text, "text must not be null");
            }
        }
    }

    public record ToolCallPart(String toolCallId, String toolName, Map<String, Object> arguments, ToolCallStatus status) implements MessagePart
    {
        public ToolCallPart {
            Objects.requireNonNull(toolCallId, "toolCallId must not be null");
            Objects.requireNonNull(toolName, "toolName must not be null");
        }

        @Override
        public PartType getType() {
            return PartType.TOOL_CALL;
        }

        public static enum ToolCallStatus {
            PENDING,
            RUNNING,
            SUCCESS,
            FAILED,
            CANCELLED,
            NEEDS_CONFIRMATION;

        }
    }

    public record ToolResultPart(String toolCallId, String toolName, String content, boolean success, ResultType resultType) implements MessagePart
    {
        public ToolResultPart {
            Objects.requireNonNull(toolCallId, "toolCallId must not be null");
            Objects.requireNonNull(toolName, "toolName must not be null");
        }

        @Override
        public PartType getType() {
            return PartType.TOOL_RESULT;
        }

        public static enum ResultType {
            TEXT,
            CODE,
            FILE_LIST,
            SEARCH_RESULTS,
            CONFIRMATION;

        }
    }
}

