/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.diagnostics;

public record EdtDiagnostic(String filePath, int lineNumber, int charStart, int charEnd, String message, Severity severity, String markerType, String source, String codeSnippet) {
    public static EdtDiagnostic fromMarker(String filePath, int lineNumber, int charStart, int charEnd, String message, int markerSeverity, String markerType, String codeSnippet) {
        return new EdtDiagnostic(filePath, lineNumber, charStart, charEnd, message, Severity.fromMarkerSeverity(markerSeverity), markerType, "marker", codeSnippet);
    }

    public static EdtDiagnostic fromAnnotation(String filePath, int lineNumber, int charStart, int charEnd, String message, Severity severity, String annotationType, String codeSnippet) {
        return new EdtDiagnostic(filePath, lineNumber, charStart, charEnd, message, severity, annotationType, "annotation", codeSnippet);
    }

    public String formatForLlm() {
        StringBuilder sb = new StringBuilder();
        sb.append("- **").append(this.severity.name()).append("** \u0441\u0442\u0440\u043e\u043a\u0430 ").append(this.lineNumber);
        if (this.charStart >= 0 && this.charEnd >= 0) {
            sb.append(" (\u043f\u043e\u0437\u0438\u0446\u0438\u044f ").append(this.charStart).append("-").append(this.charEnd).append(")");
        }
        sb.append(": ").append(this.message);
        if (this.codeSnippet != null && !this.codeSnippet.isBlank()) {
            sb.append("\n  ```\n  ").append(this.codeSnippet.trim()).append("\n  ```");
        }
        return sb.toString();
    }

    public static enum Severity {
        ERROR(2),
        WARNING(1),
        INFO(0);

        private final int level;

        private Severity(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public static Severity fromMarkerSeverity(int severity) {
            return switch (severity) {
                case 2 -> ERROR;
                case 1 -> WARNING;
                default -> INFO;
            };
        }
    }
}

