/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.dialogs;

import com.example.vibe.core.backend.BackendConfig;
import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.backend.RegistrationResult;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegistrationDialog
extends TitleAreaDialog {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Za-z0-9._%+\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z]{2,}$");
    private static final int MIN_NAME_LENGTH = 2;
    private Text emailText;
    private Text nameText;
    private Button registerButton;
    private RegistrationResult registrationResult;

    public RegistrationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f");
        shell.setMinimumSize(450, 300);
    }

    public void create() {
        super.create();
        this.setTitle("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0432 AI-\u0441\u0435\u0440\u0432\u0438\u0441\u0435");
        this.setMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label emailLabel = new Label(container, 0);
        emailLabel.setText("Email:");
        emailLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.emailText = new Text(container, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailText.addModifyListener(e -> this.validateInput());
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("\u0418\u043c\u044f:");
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addModifyListener(e -> this.validateInput());
        Label serverLabel = new Label(container, 0);
        serverLabel.setText("\u0421\u0435\u0440\u0432\u0435\u0440:");
        serverLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label serverValue = new Label(container, 0);
        serverValue.setText(BackendConfig.BASE_URL);
        serverValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.registerButton = this.createButton(parent, 0, "\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f", true);
        this.registerButton.setEnabled(false);
        this.createButton(parent, 1, "\u041e\u0442\u043c\u0435\u043d\u0430", false);
    }

    protected void okPressed() {
        String email = this.emailText.getText().trim();
        String name = this.nameText.getText().trim();
        this.registerButton.setEnabled(false);
        this.registerButton.setText("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f...");
        this.emailText.setEnabled(false);
        this.nameText.setEnabled(false);
        this.setErrorMessage(null);
        this.setMessage("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f...");
        BackendService.getInstance().register(email, name).thenAccept(result -> {
            Display display;
            Display display2 = display = this.getShell() != null ? this.getShell().getDisplay() : Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> this.handleRegistrationResult((RegistrationResult)result));
            }
        });
    }

    private void handleRegistrationResult(RegistrationResult result) {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        if (result != null && result.isSuccess()) {
            this.registrationResult = result;
            this.setReturnCode(0);
            this.close();
        } else {
            this.registerButton.setEnabled(true);
            this.registerButton.setText("\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f");
            this.emailText.setEnabled(true);
            this.nameText.setEnabled(true);
            this.setMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
            String errorMsg = result != null ? result.getError() : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
            this.setErrorMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438: " + errorMsg);
        }
    }

    private void validateInput() {
        if (this.registerButton == null || this.registerButton.isDisposed()) {
            return;
        }
        String email = this.emailText.getText().trim();
        String name = this.nameText.getText().trim();
        if (email.isEmpty()) {
            this.setErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 email");
            this.registerButton.setEnabled(false);
            return;
        }
        if (!EMAIL_PATTERN.matcher(email).matches()) {
            this.setErrorMessage("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 email");
            this.registerButton.setEnabled(false);
            return;
        }
        if (name.isEmpty()) {
            this.setErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f");
            this.registerButton.setEnabled(false);
            return;
        }
        if (name.length() < 2) {
            this.setErrorMessage("\u0418\u043c\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c 2 \u0441\u0438\u043c\u0432\u043e\u043b\u0430");
            this.registerButton.setEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        this.registerButton.setEnabled(true);
    }

    public RegistrationResult getRegistrationResult() {
        return this.registrationResult;
    }
}

