/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.diff;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.ui.diff.ProposedChange;
import com.example.vibe.ui.diff.ProposedChangeSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ChangeApplicator {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ChangeApplicator.class);
    private static ChangeApplicator instance;

    private ChangeApplicator() {
    }

    public static synchronized ChangeApplicator getInstance() {
        if (instance == null) {
            instance = new ChangeApplicator();
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public ApplyResult applyAcceptedChanges(ProposedChangeSet changeSet) {
        block8: {
            accepted = changeSet.getAcceptedChanges();
            ChangeApplicator.LOG.info("applyAcceptedChanges: %d accepted changes to apply", new Object[]{accepted.size()});
            if (accepted.isEmpty()) {
                ChangeApplicator.LOG.warn("applyAcceptedChanges: no accepted changes to apply");
                return new ApplyResult(0, 0, List.of());
            }
            for (ProposedChange change : accepted) {
                ChangeApplicator.LOG.debug("applyAcceptedChanges: will apply %s to %s (afterContent=%s)", new Object[]{change.getKind(), change.getFilePath(), change.getAfterContent() != null ? change.getAfterContent().length() + " chars" : "NULL"});
            }
            errors = new ArrayList<String>();
            successCount = 0;
            failCount = 0;
            try {
                runnable = (IWorkspaceRunnable)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/core/runtime/IProgressMonitor;)V, lambda$0(java.util.List org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/core/runtime/IProgressMonitor;)V)((ChangeApplicator)this, accepted);
                ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
                for (ProposedChange change : accepted) {
                    if (change.getStatus() == ProposedChange.ChangeStatus.APPLIED) {
                        ++successCount;
                        continue;
                    }
                    ++failCount;
                }
                break block8;
            }
            catch (CoreException e) {
                ChangeApplicator.LOG.error("applyAcceptedChanges: workspace operation failed: %s", new Object[]{e.getMessage()});
                errors.add(e.getMessage());
                ** for (change : accepted)
            }
lbl-1000:
            // 1 sources

            {
                if (change.getStatus() == ProposedChange.ChangeStatus.APPLIED) {
                    ++successCount;
                    continue;
                }
                ++failCount;
                continue;
            }
        }
        ChangeApplicator.LOG.info("applyAcceptedChanges: completed - success=%d, fail=%d", new Object[]{successCount, failCount});
        return new ApplyResult(successCount, failCount, errors);
    }

    public void applyChange(ProposedChange change) throws CoreException {
        switch (change.getKind()) {
            case CREATE: {
                this.createFile(change);
                break;
            }
            case MODIFY: 
            case REPLACE: {
                this.modifyFile(change);
                break;
            }
            case DELETE: {
                this.deleteFile(change);
            }
        }
    }

    private void createFile(ProposedChange change) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String normalizedPath = this.normalizePath(change.getFilePath());
        IFile file = root.getFile(Path.fromPortableString((String)normalizedPath));
        this.createParentFolders(file);
        ByteArrayInputStream content = new ByteArrayInputStream(change.getAfterContent().getBytes(StandardCharsets.UTF_8));
        file.create((InputStream)content, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void modifyFile(ProposedChange change) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String normalizedPath = this.normalizePath(change.getFilePath());
        LOG.debug("modifyFile: original path=%s, normalized=%s", new Object[]{change.getFilePath(), normalizedPath});
        IFile file = this.findFile(root, normalizedPath);
        LOG.debug("modifyFile: findFile returned %s", new Object[]{file != null ? file.getFullPath() : "NULL"});
        if (file == null || !file.exists()) {
            LOG.error("modifyFile: file NOT FOUND - path=%s, normalized=%s", new Object[]{change.getFilePath(), normalizedPath});
            throw new CoreException((IStatus)new Status(4, "com.example.vibe.ui", "File not found: " + change.getFilePath()));
        }
        String afterContent = change.getAfterContent();
        if (afterContent == null) {
            LOG.error("modifyFile: afterContent is NULL for %s", new Object[]{change.getFilePath()});
            throw new CoreException((IStatus)new Status(4, "com.example.vibe.ui", "afterContent is null for: " + change.getFilePath()));
        }
        LOG.info("modifyFile: writing %d bytes to %s", new Object[]{afterContent.length(), file.getFullPath()});
        ByteArrayInputStream content = new ByteArrayInputStream(afterContent.getBytes(StandardCharsets.UTF_8));
        file.setContents((InputStream)content, true, true, (IProgressMonitor)new NullProgressMonitor());
        LOG.info("modifyFile: successfully wrote to %s", new Object[]{file.getFullPath()});
    }

    private void deleteFile(ProposedChange change) throws CoreException {
        String normalizedPath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = this.findFile(root, normalizedPath = this.normalizePath(change.getFilePath()));
        if (file != null && file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void createParentFolders(IFile file) throws CoreException {
        IContainer parent = file.getParent();
        Stack<IFolder> foldersToCreate = new Stack<IFolder>();
        while (parent instanceof IFolder && !parent.exists()) {
            foldersToCreate.push((IFolder)parent);
            parent = parent.getParent();
        }
        while (!foldersToCreate.isEmpty()) {
            ((IFolder)foldersToCreate.pop()).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private String normalizePath(String path) {
        String suffix;
        if (path == null) {
            return null;
        }
        String normalized = path;
        int colonIdx = normalized.lastIndexOf(58);
        if (colonIdx > 0 && (suffix = normalized.substring(colonIdx + 1)).matches("[0-9\\-]+")) {
            normalized = normalized.substring(0, colonIdx);
            LOG.debug("normalizePath: stripped line numbers from %s -> %s", new Object[]{path, normalized});
        }
        if (normalized.startsWith("/") && !normalized.startsWith("//")) {
            normalized = normalized.substring(1);
        }
        normalized = normalized.replace('\\', '/');
        LOG.debug("normalizePath: %s -> %s", new Object[]{path, normalized});
        return normalized;
    }

    private IFile findFile(IWorkspaceRoot root, String path) {
        LOG.debug("findFile: searching for path=%s", new Object[]{path});
        try {
            IResource resource = root.findMember(path);
            LOG.debug("findFile: findMember returned %s", new Object[]{resource != null ? resource.getClass().getSimpleName() : "null"});
            if (resource instanceof IFile) {
                LOG.debug("findFile: found via findMember: %s", new Object[]{resource.getFullPath()});
                return (IFile)resource;
            }
        }
        catch (Exception e) {
            LOG.debug("findFile: findMember exception: %s", new Object[]{e.getMessage()});
        }
        try {
            IFile file = root.getFile(Path.fromPortableString((String)path));
            LOG.debug("findFile: getFile returned %s, exists=%b", new Object[]{file.getFullPath(), file.exists()});
            if (file.exists()) {
                LOG.debug("findFile: found via getFile: %s", new Object[]{file.getFullPath()});
                return file;
            }
        }
        catch (Exception e) {
            LOG.debug("findFile: getFile exception: %s", new Object[]{e.getMessage()});
        }
        LOG.warn("findFile: NOT FOUND: %s", new Object[]{path});
        return null;
    }

    private /* synthetic */ void lambda$0(List list, IProgressMonitor monitor) throws CoreException {
        for (ProposedChange change : list) {
            try {
                LOG.debug("applyAcceptedChanges: applying change for %s", new Object[]{change.getFilePath()});
                this.applyChange(change);
                change.markApplied();
                LOG.info("applyAcceptedChanges: successfully applied %s", new Object[]{change.getFilePath()});
            }
            catch (CoreException e) {
                LOG.error("applyAcceptedChanges: FAILED to apply %s: %s", new Object[]{change.getFilePath(), e.getMessage()});
                change.markFailed();
                throw e;
            }
        }
    }

    public record ApplyResult(int successCount, int failCount, List<String> errors) {
        public boolean isFullySuccessful() {
            return this.failCount == 0 && this.errors.isEmpty();
        }

        public boolean hasSuccesses() {
            return this.successCount > 0;
        }

        public int totalCount() {
            return this.successCount + this.failCount;
        }

        public String getSummary() {
            if (this.isFullySuccessful()) {
                return String.format("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439: %d", this.successCount);
            }
            if (this.successCount > 0) {
                return String.format("\u041f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e: %d, \u043e\u0448\u0438\u0431\u043e\u043a: %d", this.successCount, this.failCount);
            }
            return String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f: %d \u043e\u0448\u0438\u0431\u043e\u043a", this.failCount);
        }
    }
}

