/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.diff;

import com.example.vibe.core.diff.InlineDiffUtils;
import com.example.vibe.core.diff.LineDiffUtils;
import com.example.vibe.ui.diff.ChangeApplicator;
import com.example.vibe.ui.diff.ProposedChange;
import com.example.vibe.ui.diff.ProposedChangeSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class DiffReviewDialog
extends Dialog {
    private final ProposedChangeSet changeSet;
    private TableViewer changeListViewer;
    private StyledText beforeText;
    private StyledText afterText;
    private Label statusLabel;
    private Button acceptButton;
    private Button rejectButton;
    private Font codeFont;
    private Color addedColor;
    private Color removedColor;
    private Color placeholderColor;
    private Color headerColor;
    private Color inlineAddedColor;
    private Color inlineRemovedColor;
    private boolean isSynchronizingScroll;

    public DiffReviewDialog(Shell parentShell, ProposedChangeSet changeSet) {
        super(parentShell);
        this.changeSet = changeSet;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        shell.setSize(900, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Display display = parent.getDisplay();
        this.codeFont = new Font((Device)display, "Menlo", 11, 0);
        this.addedColor = new Color((Device)display, 220, 255, 220);
        this.removedColor = new Color((Device)display, 255, 220, 220);
        this.placeholderColor = new Color((Device)display, 240, 240, 240);
        this.headerColor = new Color((Device)display, 240, 240, 245);
        this.inlineAddedColor = new Color((Device)display, 155, 230, 155);
        this.inlineRemovedColor = new Color((Device)display, 230, 155, 155);
        this.createHeader(container);
        SashForm sash = new SashForm(container, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFileList((Composite)sash);
        this.createDiffView((Composite)sash);
        sash.setWeights(new int[]{30, 70});
        this.createChangeActions(container);
        if (!this.changeSet.isEmpty()) {
            this.changeListViewer.getTable().select(0);
            this.showSelectedChange();
        }
        return container;
    }

    private void createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        header.setBackground(this.headerColor);
        Label titleLabel = new Label(header, 0);
        titleLabel.setText(String.format("\u041f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f: %d \u0444\u0430\u0439\u043b\u043e\u0432", this.changeSet.size()));
        titleLabel.setBackground(this.headerColor);
        titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusLabel = new Label(header, 0);
        this.statusLabel.setBackground(this.headerColor);
        this.updateStatusLabel();
    }

    private void createFileList(Composite parent) {
        Composite listContainer = new Composite(parent, 0);
        listContainer.setLayout((Layout)new GridLayout(1, false));
        Label listLabel = new Label(listContainer, 0);
        listLabel.setText("\u0424\u0430\u0439\u043b\u044b:");
        this.changeListViewer = new TableViewer(listContainer, 68096);
        Table table = this.changeListViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableViewerColumn statusCol = new TableViewerColumn(this.changeListViewer, 0);
        statusCol.getColumn().setText("");
        statusCol.getColumn().setWidth(30);
        statusCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProposedChange change = (ProposedChange)element;
                return switch (change.getStatus()) {
                    case ProposedChange.ChangeStatus.PENDING -> "\u25cb";
                    case ProposedChange.ChangeStatus.ACCEPTED -> "\u2713";
                    case ProposedChange.ChangeStatus.REJECTED -> "\u2717";
                    case ProposedChange.ChangeStatus.APPLIED -> "\u2714";
                    case ProposedChange.ChangeStatus.FAILED -> "\u26a0";
                    default -> throw new IncompatibleClassChangeError();
                };
            }
        });
        TableViewerColumn fileCol = new TableViewerColumn(this.changeListViewer, 0);
        fileCol.getColumn().setText("\u0424\u0430\u0439\u043b");
        fileCol.getColumn().setWidth(200);
        fileCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProposedChange change = (ProposedChange)element;
                return change.getFileName();
            }
        });
        TableViewerColumn actionCol = new TableViewerColumn(this.changeListViewer, 0);
        actionCol.getColumn().setText("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435");
        actionCol.getColumn().setWidth(80);
        actionCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProposedChange change = (ProposedChange)element;
                return switch (change.getKind()) {
                    case ProposedChange.ChangeKind.CREATE -> "\u0421\u043e\u0437\u0434\u0430\u0442\u044c";
                    case ProposedChange.ChangeKind.MODIFY -> "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c";
                    case ProposedChange.ChangeKind.REPLACE -> "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c";
                    case ProposedChange.ChangeKind.DELETE -> "\u0423\u0434\u0430\u043b\u0438\u0442\u044c";
                    default -> throw new IncompatibleClassChangeError();
                };
            }
        });
        this.changeListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.changeListViewer.setInput(this.changeSet.getChanges());
        this.changeListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiffReviewDialog.this.showSelectedChange();
            }
        });
    }

    private void createDiffView(Composite parent) {
        Composite diffContainer = new Composite(parent, 0);
        diffContainer.setLayout((Layout)new GridLayout(1, false));
        SashForm diffSash = new SashForm(diffContainer, 256);
        diffSash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite beforeContainer = new Composite((Composite)diffSash, 0);
        beforeContainer.setLayout((Layout)new GridLayout(1, false));
        Label beforeLabel = new Label(beforeContainer, 0);
        beforeLabel.setText("\u0414\u043e:");
        this.beforeText = new StyledText(beforeContainer, 2826);
        this.beforeText.setFont(this.codeFont);
        this.beforeText.setEditable(false);
        this.beforeText.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite afterContainer = new Composite((Composite)diffSash, 0);
        afterContainer.setLayout((Layout)new GridLayout(1, false));
        Label afterLabel = new Label(afterContainer, 0);
        afterLabel.setText("\u041f\u043e\u0441\u043b\u0435:");
        this.afterText = new StyledText(afterContainer, 2826);
        this.afterText.setFont(this.codeFont);
        this.afterText.setEditable(false);
        this.afterText.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrollBar beforeVBar = this.beforeText.getVerticalBar();
        ScrollBar afterVBar = this.afterText.getVerticalBar();
        if (beforeVBar != null && afterVBar != null) {
            beforeVBar.addListener(13, e -> this.syncScroll(this.beforeText, this.afterText));
            afterVBar.addListener(13, e -> this.syncScroll(this.afterText, this.beforeText));
        }
        diffSash.setWeights(new int[]{50, 50});
    }

    private void syncScroll(StyledText source, StyledText target) {
        if (this.isSynchronizingScroll) {
            return;
        }
        this.isSynchronizingScroll = true;
        try {
            int topIndex = source.getTopIndex();
            int maxTargetIndex = Math.max(0, target.getLineCount() - 1);
            target.setTopIndex(Math.min(topIndex, maxTargetIndex));
        }
        finally {
            this.isSynchronizingScroll = false;
        }
    }

    private void createChangeActions(Composite parent) {
        Composite actionBar = new Composite(parent, 0);
        actionBar.setLayout((Layout)new GridLayout(4, false));
        actionBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.acceptButton = new Button(actionBar, 8);
        this.acceptButton.setText("\u041f\u0440\u0438\u043d\u044f\u0442\u044c");
        this.acceptButton.addListener(13, e -> this.acceptSelected());
        this.rejectButton = new Button(actionBar, 8);
        this.rejectButton.setText("\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c");
        this.rejectButton.addListener(13, e -> this.rejectSelected());
        Label spacer = new Label(actionBar, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button acceptAllButton = new Button(actionBar, 8);
        acceptAllButton.setText("\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u0432\u0441\u0435");
        acceptAllButton.addListener(13, e -> this.acceptAll());
        Button rejectAllButton = new Button(actionBar, 8);
        rejectAllButton.setText("\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c \u0432\u0441\u0435");
        rejectAllButton.addListener(13, e -> this.rejectAll());
    }

    private void showSelectedChange() {
        IStructuredSelection selection = this.changeListViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            this.beforeText.setText("");
            this.afterText.setText("");
            this.beforeText.setBackground(null);
            this.afterText.setBackground(null);
            this.clearLineBackgrounds(this.beforeText);
            this.clearLineBackgrounds(this.afterText);
            this.updateButtonState(null);
            return;
        }
        ProposedChange change = (ProposedChange)selection.getFirstElement();
        String before = change.getBeforeContent();
        String after = change.getAfterContent();
        if (before == null || after == null) {
            this.beforeText.setText(before != null ? before : "(\u043d\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b)");
            if (before == null) {
                this.beforeText.setBackground(this.removedColor);
            } else {
                this.beforeText.setBackground(null);
            }
            this.clearLineBackgrounds(this.beforeText);
            this.afterText.setText(after != null ? after : "(\u0443\u0434\u0430\u043b\u0451\u043d)");
            if (after == null) {
                this.afterText.setBackground(this.removedColor);
            } else if (before == null) {
                this.afterText.setBackground(this.addedColor);
            } else {
                this.afterText.setBackground(null);
            }
            this.clearLineBackgrounds(this.afterText);
            this.updateButtonState(change);
            return;
        }
        LineDiffUtils.DiffResult diff = LineDiffUtils.computeDiff((String)before, (String)after);
        List alignedRows = diff.getAlignedRowsWithContext(3);
        StringBuilder beforeBuilder = new StringBuilder();
        StringBuilder afterBuilder = new StringBuilder();
        ArrayList<Integer> beforeLineOffsets = new ArrayList<Integer>();
        ArrayList<Integer> afterLineOffsets = new ArrayList<Integer>();
        ArrayList<String> beforeLineContents = new ArrayList<String>();
        ArrayList<String> afterLineContents = new ArrayList<String>();
        int i = 0;
        while (i < alignedRows.size()) {
            LineDiffUtils.AlignedRow row = (LineDiffUtils.AlignedRow)alignedRows.get(i);
            if (i > 0) {
                beforeBuilder.append('\n');
                afterBuilder.append('\n');
            }
            beforeLineOffsets.add(beforeBuilder.length());
            afterLineOffsets.add(afterBuilder.length());
            boolean isSeparator = row.getLeftLineNumber() < 0 && row.getRightLineNumber() < 0 && "...".equals(row.getLeftContent()) && "...".equals(row.getRightContent());
            String left = row.getLeftLineNumber() < 0 && !isSeparator ? "" : row.getLeftContent();
            String right = row.getRightLineNumber() < 0 && !isSeparator ? "" : row.getRightContent();
            left = left != null ? left : "";
            right = right != null ? right : "";
            beforeBuilder.append(left);
            afterBuilder.append(right);
            beforeLineContents.add(left);
            afterLineContents.add(right);
            ++i;
        }
        this.beforeText.setText(beforeBuilder.toString());
        this.afterText.setText(afterBuilder.toString());
        this.beforeText.setBackground(null);
        this.afterText.setBackground(null);
        this.applyLineHighlights(alignedRows);
        this.applyInlineHighlights(alignedRows, beforeLineOffsets, afterLineOffsets, beforeLineContents, afterLineContents);
        this.updateButtonState(change);
    }

    private void applyLineHighlights(List<LineDiffUtils.AlignedRow> alignedRows) {
        this.clearLineBackgrounds(this.beforeText);
        this.clearLineBackgrounds(this.afterText);
        int rowCount = alignedRows.size();
        int lineIndex = 0;
        while (lineIndex < rowCount) {
            boolean rightPlaceholder;
            LineDiffUtils.AlignedRow row = alignedRows.get(lineIndex);
            boolean leftPlaceholder = row.getLeftLineNumber() < 0;
            boolean bl = rightPlaceholder = row.getRightLineNumber() < 0;
            if (leftPlaceholder) {
                this.beforeText.setLineBackground(lineIndex, 1, this.placeholderColor);
            }
            if (rightPlaceholder) {
                this.afterText.setLineBackground(lineIndex, 1, this.placeholderColor);
            }
            switch (row.getType()) {
                case DELETED: {
                    this.beforeText.setLineBackground(lineIndex, 1, this.removedColor);
                    break;
                }
                case ADDED: {
                    this.afterText.setLineBackground(lineIndex, 1, this.addedColor);
                    break;
                }
                case MODIFIED: {
                    this.beforeText.setLineBackground(lineIndex, 1, this.removedColor);
                    this.afterText.setLineBackground(lineIndex, 1, this.addedColor);
                    break;
                }
            }
            ++lineIndex;
        }
    }

    private void applyInlineHighlights(List<LineDiffUtils.AlignedRow> alignedRows, List<Integer> beforeLineOffsets, List<Integer> afterLineOffsets, List<String> beforeLineContents, List<String> afterLineContents) {
        this.beforeText.replaceStyleRanges(0, this.beforeText.getCharCount(), new StyleRange[0]);
        this.afterText.replaceStyleRanges(0, this.afterText.getCharCount(), new StyleRange[0]);
        ArrayList<StyleRange> beforeRanges = new ArrayList<StyleRange>();
        ArrayList<StyleRange> afterRanges = new ArrayList<StyleRange>();
        int i = 0;
        while (i < alignedRows.size()) {
            LineDiffUtils.AlignedRow row = alignedRows.get(i);
            if (row.getType() == LineDiffUtils.AlignedRow.RowType.MODIFIED) {
                String leftContent = beforeLineContents.get(i);
                String rightContent = afterLineContents.get(i);
                int beforeOffset = beforeLineOffsets.get(i);
                int afterOffset = afterLineOffsets.get(i);
                if (!leftContent.isEmpty() || !rightContent.isEmpty()) {
                    StyleRange styleRange;
                    int length;
                    int start;
                    InlineDiffUtils.InlineDiffResult inlineDiff = InlineDiffUtils.diff((String)leftContent, (String)rightContent);
                    for (InlineDiffUtils.HighlightRange range : inlineDiff.getLeftRanges()) {
                        start = beforeOffset + range.getStart();
                        length = range.getLength();
                        if (start < 0 || start + length > this.beforeText.getCharCount()) continue;
                        styleRange = new StyleRange();
                        styleRange.start = start;
                        styleRange.length = length;
                        styleRange.background = this.inlineRemovedColor;
                        beforeRanges.add(styleRange);
                    }
                    for (InlineDiffUtils.HighlightRange range : inlineDiff.getRightRanges()) {
                        start = afterOffset + range.getStart();
                        length = range.getLength();
                        if (start < 0 || start + length > this.afterText.getCharCount()) continue;
                        styleRange = new StyleRange();
                        styleRange.start = start;
                        styleRange.length = length;
                        styleRange.background = this.inlineAddedColor;
                        afterRanges.add(styleRange);
                    }
                }
            }
            ++i;
        }
        if (!beforeRanges.isEmpty()) {
            this.beforeText.setStyleRanges(beforeRanges.toArray(new StyleRange[0]));
        }
        if (!afterRanges.isEmpty()) {
            this.afterText.setStyleRanges(afterRanges.toArray(new StyleRange[0]));
        }
    }

    private void clearLineBackgrounds(StyledText text) {
        int lineCount = text.getLineCount();
        int i = 0;
        while (i < lineCount) {
            text.setLineBackground(i, 1, null);
            ++i;
        }
    }

    private void updateButtonState(ProposedChange change) {
        boolean canModify = change != null && change.isPending();
        this.acceptButton.setEnabled(canModify);
        this.rejectButton.setEnabled(canModify);
    }

    private void acceptSelected() {
        IStructuredSelection selection = this.changeListViewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            ProposedChange change = (ProposedChange)selection.getFirstElement();
            change.accept();
            this.changeListViewer.refresh((Object)change);
            this.updateStatusLabel();
            this.updateButtonState(change);
            this.selectNext();
        }
    }

    private void rejectSelected() {
        IStructuredSelection selection = this.changeListViewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            ProposedChange change = (ProposedChange)selection.getFirstElement();
            change.reject();
            this.changeListViewer.refresh((Object)change);
            this.updateStatusLabel();
            this.updateButtonState(change);
            this.selectNext();
        }
    }

    private void selectNext() {
        List<ProposedChange> changes = this.changeSet.getChanges();
        int currentIndex = this.changeListViewer.getTable().getSelectionIndex();
        int i = currentIndex + 1;
        while (i < changes.size()) {
            if (changes.get(i).isPending()) {
                this.changeListViewer.getTable().select(i);
                this.showSelectedChange();
                return;
            }
            ++i;
        }
        i = 0;
        while (i < currentIndex) {
            if (changes.get(i).isPending()) {
                this.changeListViewer.getTable().select(i);
                this.showSelectedChange();
                return;
            }
            ++i;
        }
    }

    private void acceptAll() {
        this.changeSet.acceptAll();
        this.changeListViewer.refresh();
        this.updateStatusLabel();
        this.showSelectedChange();
    }

    private void rejectAll() {
        this.changeSet.rejectAll();
        this.changeListViewer.refresh();
        this.updateStatusLabel();
        this.showSelectedChange();
    }

    private void updateStatusLabel() {
        int pending = this.changeSet.getPendingCount();
        int accepted = this.changeSet.getAcceptedCount();
        int rejected = this.changeSet.getRejectedCount();
        this.statusLabel.setText(String.format("\u041e\u0436\u0438\u0434\u0430\u0435\u0442: %d | \u041f\u0440\u0438\u043d\u044f\u0442\u043e: %d | \u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043e: %d", pending, accepted, rejected));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0435", true);
        this.createButton(parent, 1, "\u041e\u0442\u043c\u0435\u043d\u0430", false);
    }

    protected void okPressed() {
        if (!this.changeSet.hasAcceptedChanges()) {
            super.cancelPressed();
            return;
        }
        ChangeApplicator applicator = ChangeApplicator.getInstance();
        ChangeApplicator.ApplyResult result = applicator.applyAcceptedChanges(this.changeSet);
        result.isFullySuccessful();
        super.okPressed();
    }

    public boolean close() {
        if (this.codeFont != null && !this.codeFont.isDisposed()) {
            this.codeFont.dispose();
        }
        if (this.addedColor != null && !this.addedColor.isDisposed()) {
            this.addedColor.dispose();
        }
        if (this.removedColor != null && !this.removedColor.isDisposed()) {
            this.removedColor.dispose();
        }
        if (this.placeholderColor != null && !this.placeholderColor.isDisposed()) {
            this.placeholderColor.dispose();
        }
        if (this.headerColor != null && !this.headerColor.isDisposed()) {
            this.headerColor.dispose();
        }
        if (this.inlineAddedColor != null && !this.inlineAddedColor.isDisposed()) {
            this.inlineAddedColor.dispose();
        }
        if (this.inlineRemovedColor != null && !this.inlineRemovedColor.isDisposed()) {
            this.inlineRemovedColor.dispose();
        }
        return super.close();
    }

    public boolean openAndApply() {
        return this.open() == 0;
    }
}

