/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.editor;

import com.example.vibe.core.diff.CodeChange;
import com.example.vibe.core.diff.CodeDiffUtils;
import com.example.vibe.core.diff.ICodeApplicator;
import com.example.vibe.ui.editor.EditorCodeApplicator;
import com.example.vibe.ui.internal.VibeUiPlugin;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeApplicationService {
    private static CodeApplicationService instance;

    private CodeApplicationService() {
    }

    public static synchronized CodeApplicationService getInstance() {
        if (instance == null) {
            instance = new CodeApplicationService();
        }
        return instance;
    }

    public boolean insertAtCursor(String code) {
        ITextEditor editor = this.getActiveTextEditor();
        if (editor == null || code == null || code.isEmpty()) {
            return false;
        }
        ITextSelection selection = this.getSelection(editor);
        if (selection == null) {
            return false;
        }
        EditorCodeApplicator applicator = new EditorCodeApplicator(editor);
        CodeChange change = CodeChange.insert((int)selection.getOffset(), (String)code).build();
        ICodeApplicator.ApplyResult result = applicator.apply(change);
        if (result.isSuccess()) {
            applicator.moveCaret(selection.getOffset() + code.length());
        }
        return result.isSuccess();
    }

    public boolean replaceSelection(String newCode) {
        ITextEditor editor = this.getActiveTextEditor();
        if (editor == null || newCode == null) {
            return false;
        }
        ITextSelection selection = this.getSelection(editor);
        if (selection == null || selection.getLength() == 0) {
            return this.insertAtCursor(newCode);
        }
        EditorCodeApplicator applicator = new EditorCodeApplicator(editor);
        CodeChange change = CodeChange.replace((int)selection.getOffset(), (int)selection.getLength(), (String)selection.getText(), (String)newCode).build();
        ICodeApplicator.ApplyResult result = applicator.apply(change);
        if (result.isSuccess()) {
            applicator.moveCaret(selection.getOffset() + newCode.length());
        }
        return result.isSuccess();
    }

    public boolean applyFromResponse(String aiResponse, boolean replaceSelection) {
        String code = CodeDiffUtils.extractFirstCodeBlock((String)aiResponse);
        if (code == null || code.isEmpty()) {
            code = CodeDiffUtils.stripMarkdown((String)aiResponse);
        }
        if (code == null || code.isEmpty()) {
            this.showMessage("No code found", "Could not extract code from the AI response.");
            return false;
        }
        if (replaceSelection) {
            return this.replaceSelection(code);
        }
        return this.insertAtCursor(code);
    }

    public boolean applyWithConfirmation(String aiResponse, String title, boolean replaceSelection) {
        String code = CodeDiffUtils.extractFirstCodeBlock((String)aiResponse);
        if (code == null || code.isEmpty()) {
            code = CodeDiffUtils.stripMarkdown((String)aiResponse);
        }
        if (code == null || code.isEmpty()) {
            this.showMessage("No code found", "Could not extract code from the AI response.");
            return false;
        }
        Shell shell = this.getShell();
        if (shell == null) {
            return false;
        }
        String message = replaceSelection ? "Replace the selected code with the AI-generated code?" : "Insert the AI-generated code at cursor position?";
        boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)title, (String)(message + "\n\nCode preview:\n" + this.truncateForDisplay(code)));
        if (!confirmed) {
            return false;
        }
        if (replaceSelection) {
            return this.replaceSelection(code);
        }
        return this.insertAtCursor(code);
    }

    public ICodeApplicator.ApplyResult applyChanges(List<CodeChange> changes, String undoLabel) {
        ITextEditor editor = this.getActiveTextEditor();
        if (editor == null) {
            return ICodeApplicator.ApplyResult.failure((String)"No active text editor", null);
        }
        EditorCodeApplicator applicator = new EditorCodeApplicator(editor);
        return applicator.applyWithUndo(changes, undoLabel);
    }

    public SelectionInfo getCurrentSelection() {
        ITextEditor editor = this.getActiveTextEditor();
        if (editor == null) {
            return null;
        }
        ITextSelection selection = this.getSelection(editor);
        if (selection == null) {
            return null;
        }
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String fileName = this.getEditorFileName(editor);
        return new SelectionInfo(selection.getOffset(), selection.getLength(), selection.getText(), document != null ? document.get() : null, fileName);
    }

    private String getEditorFileName(ITextEditor editor) {
        try {
            if (editor.getEditorInput() != null) {
                return editor.getEditorInput().getName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private ITextEditor getActiveTextEditor() {
        IWorkbenchWindow window;
        block4: {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) break block4;
            return null;
        }
        try {
            IEditorPart editor = window.getActivePage().getActiveEditor();
            if (editor instanceof ITextEditor) {
                return (ITextEditor)editor;
            }
        }
        catch (Exception e) {
            VibeUiPlugin.log(e);
        }
        return null;
    }

    private ITextSelection getSelection(ITextEditor editor) {
        try {
            return (ITextSelection)editor.getSelectionProvider().getSelection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Shell getShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display.getActiveShell();
    }

    private void showMessage(String title, String message) {
        Shell shell = this.getShell();
        if (shell != null) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
        }
    }

    private String truncateForDisplay(String code) {
        if (code.length() <= 500) {
            return code;
        }
        return code.substring(0, 500) + "\n... (truncated)";
    }

    public static class SelectionInfo {
        private final int offset;
        private final int length;
        private final String selectedText;
        private final String documentText;
        private final String fileName;

        public SelectionInfo(int offset, int length, String selectedText, String documentText, String fileName) {
            this.offset = offset;
            this.length = length;
            this.selectedText = selectedText;
            this.documentText = documentText;
            this.fileName = fileName;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getSelectedText() {
            return this.selectedText;
        }

        public String getDocumentText() {
            return this.documentText;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean hasSelection() {
            return this.length > 0;
        }

        public boolean hasDocument() {
            return this.documentText != null && !this.documentText.isEmpty();
        }
    }
}

