/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.markdown;

import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class CodeBlockNodeRenderer
implements NodeRenderer {
    public CodeBlockNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet handlers = new HashSet();
        handlers.add(new NodeRenderingHandler(FencedCodeBlock.class, this::renderFencedCodeBlock));
        handlers.add(new NodeRenderingHandler(IndentedCodeBlock.class, this::renderIndentedCodeBlock));
        handlers.add(new NodeRenderingHandler(Code.class, this::renderInlineCode));
        return handlers;
    }

    private void renderFencedCodeBlock(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        String language = node.getInfo() != null ? node.getInfo().toString().trim() : "";
        String code = node.getContentChars() != null ? node.getContentChars().toString() : "";
        this.renderCodeBlock(html, language, code);
    }

    private void renderIndentedCodeBlock(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        String code = node.getContentChars() != null ? node.getContentChars().toString() : "";
        this.renderCodeBlock(html, "", code);
    }

    private void renderInlineCode(Code node, NodeRendererContext context, HtmlWriter html) {
        String code = node.getText() != null ? node.getText().toString() : "";
        html.raw((CharSequence)"<code class=\"inline\">");
        html.raw((CharSequence)this.escapeHtml(code));
        html.raw((CharSequence)"</code>");
    }

    private void renderCodeBlock(HtmlWriter html, String language, String code) {
        html.line();
        html.raw((CharSequence)"<div class=\"code-block\"");
        if (language != null && !language.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)" data-language=\"")).raw((CharSequence)this.escapeAttribute(language))).raw((CharSequence)"\"");
        }
        html.raw((CharSequence)">");
        html.raw((CharSequence)"<div class=\"code-header\">");
        if (language != null && !language.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"<span class=\"code-lang\">")).raw((CharSequence)this.escapeHtml(language))).raw((CharSequence)"</span>");
        }
        html.raw((CharSequence)"<button class=\"copy-btn\" onclick=\"copyCode(this)\">\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c</button>");
        html.raw((CharSequence)"</div>");
        html.raw((CharSequence)"<pre><code");
        if (language != null && !language.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)" class=\"language-")).raw((CharSequence)this.escapeAttribute(language))).raw((CharSequence)"\"");
        }
        html.raw((CharSequence)">");
        html.raw((CharSequence)this.escapeHtml(code.trim()));
        html.raw((CharSequence)"</code></pre>");
        html.raw((CharSequence)"</div>");
        html.line();
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String escapeAttribute(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new CodeBlockNodeRenderer(options);
        }
    }
}

