/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.markdown;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class SimpleMarkdownParser {
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("```(\\w*)[\\t ]*\\n?([\\s\\S]*?)```", 8);
    private static final Pattern TABLE_PATTERN = Pattern.compile("(^\\|.+\\|\\s*\\r?$\\n)(^\\|[-:|\\s]+\\|\\s*\\r?$\\n)((?:^\\|.+\\|\\s*\\r?$\\n?)+)", 8);
    private static final Pattern HEADER_PATTERN = Pattern.compile("^(#{1,6})\\s+(.+)$", 8);
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.+?)\\*\\*|__(.+?)__");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("(?<![\\*_])\\*([^\\*]+?)\\*(?![\\*_])|(?<![\\*_])_([^_]+?)_(?![\\*_])");
    private static final Pattern INLINE_CODE_PATTERN = Pattern.compile("`([^`]+)`");
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\(([^)]+)\\)");
    private static final Pattern UNORDERED_LIST_PATTERN = Pattern.compile("^[\\s]*[-*+]\\s+(.+)$", 8);
    private static final Pattern ORDERED_LIST_PATTERN = Pattern.compile("^[\\s]*\\d+\\.\\s+(.+)$", 8);
    private static final Pattern HR_PATTERN = Pattern.compile("^[-*_]{3,}\\s*$", 8);
    private static final Pattern BLOCKQUOTE_PATTERN = Pattern.compile("^>\\s*(.+)$", 8);
    private static final String PLACEHOLDER_PREFIX = "CODEBLOCKSTART";
    private static final String PLACEHOLDER_SUFFIX = "CODEBLOCKEND";
    private final List<String> codeBlocks = new ArrayList<String>();

    public String toHtml(String markdown) {
        if (markdown == null || markdown.isEmpty()) {
            return "";
        }
        this.codeBlocks.clear();
        String html = markdown.replace("\r\n", "\n").replace("\r", "\n");
        html = this.extractCodeBlocks(html);
        html = this.escapeHtml(html);
        html = this.processTables(html);
        html = this.processHeaders(html);
        html = this.processBlockquotes(html);
        html = this.processHorizontalRules(html);
        html = this.processLists(html);
        html = this.processBold(html);
        html = this.processItalic(html);
        html = this.processInlineCode(html);
        html = this.processLinks(html);
        html = this.processParagraphs(html);
        html = this.restoreCodeBlocks(html);
        return html;
    }

    private String extractCodeBlocks(String text) {
        Matcher matcher = CODE_BLOCK_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String language = matcher.group(1);
            String code = matcher.group(2);
            int index = this.codeBlocks.size();
            String codeHtml = this.buildCodeBlockHtml(language, code);
            this.codeBlocks.add(codeHtml);
            String placeholder = PLACEHOLDER_PREFIX + index + PLACEHOLDER_SUFFIX;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(placeholder));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String restoreCodeBlocks(String text) {
        String result = text;
        int i = 0;
        while (i < this.codeBlocks.size()) {
            String placeholder = PLACEHOLDER_PREFIX + i + PLACEHOLDER_SUFFIX;
            result = result.replace(placeholder, this.codeBlocks.get(i));
            result = result.replace("%%CODEBLOCK_" + i + "%%", this.codeBlocks.get(i));
            result = result.replace("%%CODEBLOCK" + i + "%%", this.codeBlocks.get(i));
            ++i;
        }
        result = this.cleanupUnresolvedPlaceholders(result);
        return result;
    }

    private String cleanupUnresolvedPlaceholders(String text) {
        return text.replaceAll(Pattern.quote(PLACEHOLDER_PREFIX) + "\\d+" + Pattern.quote(PLACEHOLDER_SUFFIX), "");
    }

    private String buildCodeBlockHtml(String language, String code) {
        String escapedCode = this.escapeHtml(code.trim());
        String langClass = language != null && !language.isEmpty() ? " class=\"language-" + language + "\"" : "";
        String langAttr = language != null && !language.isEmpty() ? " data-language=\"" + this.escapeHtml(language) + "\"" : "";
        return "<div class=\"code-block\"" + langAttr + "><div class=\"code-header\">" + (String)(language != null && !language.isEmpty() ? "<span class=\"code-lang\">" + this.escapeHtml(language) + "</span>" : "") + "<button class=\"copy-btn\" onclick=\"copyCode(this)\">\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c</button></div><pre><code" + langClass + ">" + escapedCode + "</code></pre></div>";
    }

    private String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private String processTables(String text) {
        Matcher matcher = TABLE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String[] rows;
            String headerRow = matcher.group(1).trim();
            String alignRow = matcher.group(2).trim();
            String dataRows = matcher.group(3);
            StringBuilder table = new StringBuilder();
            table.append("<table>\n<thead>\n<tr>\n");
            String[] alignCells = alignRow.split("\\|");
            ArrayList<String> alignments = new ArrayList<String>();
            String[] stringArray = alignCells;
            int n = alignCells.length;
            int n2 = 0;
            while (n2 < n) {
                String cell = stringArray[n2];
                if (!(cell = cell.trim()).isEmpty()) {
                    if (cell.startsWith(":") && cell.endsWith(":")) {
                        alignments.add("center");
                    } else if (cell.endsWith(":")) {
                        alignments.add("right");
                    } else {
                        alignments.add("left");
                    }
                }
                ++n2;
            }
            String[] headerCells = headerRow.split("\\|");
            int colIndex = 0;
            String[] stringArray2 = headerCells;
            int n3 = headerCells.length;
            int n4 = 0;
            while (n4 < n3) {
                String cell = stringArray2[n4];
                if (!(cell = cell.trim()).isEmpty()) {
                    String align = colIndex < alignments.size() ? (String)alignments.get(colIndex) : "left";
                    table.append("<th style=\"text-align:").append(align).append("\">").append(cell).append("</th>\n");
                    ++colIndex;
                }
                ++n4;
            }
            table.append("</tr>\n</thead>\n<tbody>\n");
            String[] stringArray3 = rows = dataRows.split("\\n");
            int n5 = rows.length;
            n3 = 0;
            while (n3 < n5) {
                String row = stringArray3[n3];
                if (!(row = row.trim()).isEmpty() && row.startsWith("|")) {
                    table.append("<tr>\n");
                    String[] cells = row.split("\\|");
                    colIndex = 0;
                    String[] stringArray4 = cells;
                    int n6 = cells.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String cell = stringArray4[n7];
                        if (!(cell = cell.trim()).isEmpty()) {
                            String align = colIndex < alignments.size() ? (String)alignments.get(colIndex) : "left";
                            table.append("<td style=\"text-align:").append(align).append("\">").append(cell).append("</td>\n");
                            ++colIndex;
                        }
                        ++n7;
                    }
                    table.append("</tr>\n");
                }
                ++n3;
            }
            table.append("</tbody>\n</table>");
            matcher.appendReplacement(sb, Matcher.quoteReplacement(table.toString()));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processHeaders(String text) {
        Matcher matcher = HEADER_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int level = matcher.group(1).length();
            String content = matcher.group(2);
            matcher.appendReplacement(sb, "<h" + level + ">" + content + "</h" + level + ">");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processBlockquotes(String text) {
        Matcher matcher = BLOCKQUOTE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String content = matcher.group(1);
            matcher.appendReplacement(sb, "<blockquote>" + content + "</blockquote>");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processHorizontalRules(String text) {
        return HR_PATTERN.matcher(text).replaceAll("<hr>");
    }

    private String processLists(String text) {
        String[] lines = text.split("\\n");
        StringBuilder result = new StringBuilder();
        boolean inUl = false;
        boolean inOl = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher ulMatcher = UNORDERED_LIST_PATTERN.matcher(line);
            Matcher olMatcher = ORDERED_LIST_PATTERN.matcher(line);
            if (ulMatcher.matches()) {
                if (inOl) {
                    result.append("</ol>\n");
                    inOl = false;
                }
                if (!inUl) {
                    result.append("<ul>\n");
                    inUl = true;
                }
                result.append("<li>").append(ulMatcher.group(1)).append("</li>\n");
            } else if (olMatcher.matches()) {
                if (inUl) {
                    result.append("</ul>\n");
                    inUl = false;
                }
                if (!inOl) {
                    result.append("<ol>\n");
                    inOl = true;
                }
                result.append("<li>").append(olMatcher.group(1)).append("</li>\n");
            } else {
                if (inUl) {
                    result.append("</ul>\n");
                    inUl = false;
                }
                if (inOl) {
                    result.append("</ol>\n");
                    inOl = false;
                }
                result.append(line).append("\n");
            }
            ++n2;
        }
        if (inUl) {
            result.append("</ul>\n");
        }
        if (inOl) {
            result.append("</ol>\n");
        }
        return result.toString();
    }

    private String processBold(String text) {
        Matcher matcher = BOLD_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String content = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            matcher.appendReplacement(sb, "<strong>" + Matcher.quoteReplacement(content) + "</strong>");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processItalic(String text) {
        Matcher matcher = ITALIC_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String content = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            matcher.appendReplacement(sb, "<em>" + Matcher.quoteReplacement(content) + "</em>");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processInlineCode(String text) {
        Matcher matcher = INLINE_CODE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String code = matcher.group(1);
            matcher.appendReplacement(sb, "<code class=\"inline\">" + Matcher.quoteReplacement(code) + "</code>");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processLinks(String text) {
        Matcher matcher = LINK_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String linkText = matcher.group(1);
            String url = matcher.group(2);
            matcher.appendReplacement(sb, "<a href=\"" + Matcher.quoteReplacement(url) + "\" target=\"_blank\">" + Matcher.quoteReplacement(linkText) + "</a>");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processParagraphs(String text) {
        String[] lines = text.split("\\n\\n+");
        StringBuilder result = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String paragraph = stringArray[n2];
            if (!(paragraph = paragraph.trim()).isEmpty()) {
                boolean hasCodeBlock;
                boolean bl = hasCodeBlock = paragraph.contains(PLACEHOLDER_PREFIX) || paragraph.contains("%%CODEBLOCK_") || paragraph.contains("%%CODEBLOCK");
                if (paragraph.startsWith("<h") || paragraph.startsWith("<table") || paragraph.startsWith("<ul") || paragraph.startsWith("<ol") || paragraph.startsWith("<blockquote") || paragraph.startsWith("<hr") || paragraph.startsWith("<div") || hasCodeBlock) {
                    if (hasCodeBlock) {
                        paragraph = this.processCodeBlockParagraph(paragraph);
                    }
                    result.append(paragraph).append("\n");
                } else {
                    paragraph = paragraph.replace("\n", "<br>\n");
                    result.append("<p>").append(paragraph).append("</p>\n");
                }
            }
            ++n2;
        }
        return result.toString();
    }

    private String processCodeBlockParagraph(String paragraph) {
        String textAfter;
        StringBuilder result = new StringBuilder();
        String patternStr = Pattern.quote(PLACEHOLDER_PREFIX) + "\\d+" + Pattern.quote(PLACEHOLDER_SUFFIX) + "|%%CODEBLOCK_?\\d+%%";
        Matcher matcher = Pattern.compile(patternStr).matcher(paragraph);
        int lastEnd = 0;
        while (matcher.find()) {
            String textBefore = paragraph.substring(lastEnd, matcher.start()).trim();
            if (!textBefore.isEmpty()) {
                textBefore = textBefore.replace("\n", "<br>\n");
                result.append("<p>").append(textBefore).append("</p>\n");
            }
            result.append(matcher.group()).append("\n");
            lastEnd = matcher.end();
        }
        if (lastEnd < paragraph.length() && !(textAfter = paragraph.substring(lastEnd).trim()).isEmpty()) {
            textAfter = textAfter.replace("\n", "<br>\n");
            result.append("<p>").append(textAfter).append("</p>\n");
        }
        return result.toString().trim();
    }
}

