/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.preferences;

import com.example.vibe.core.backend.BackendConfig;
import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.backend.RegistrationResult;
import com.example.vibe.core.backend.UsageInfo;
import com.example.vibe.core.internal.VibeCorePlugin;
import com.example.vibe.core.state.VibeStateService;
import com.example.vibe.ui.dialogs.RegistrationDialog;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AccountPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.example.vibe.ui.preferences.AccountPreferencePage";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance(Locale.forLanguageTag("ru"));
    private Composite stackContainer;
    private StackLayout stackLayout;
    private Composite configuredComposite;
    private Composite notConfiguredComposite;
    private Label statusLabel;
    private Label serverLabel;
    private Label userEmailLabel;
    private Label budgetLabel;
    private Label spentLabel;
    private Label remainingLabel;
    private ProgressBar usageProgressBar;
    private Label promptTokensLabel;
    private Label completionTokensLabel;
    private Label totalTokensLabel;
    private Label resetDateLabel;

    public AccountPreferencePage() {
        this.setDescription("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u043c AI-\u0441\u0435\u0440\u0432\u0438\u0441\u0430");
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.stackContainer = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackContainer.setLayout((Layout)this.stackLayout);
        this.stackContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConfiguredComposite(this.stackContainer);
        this.createNotConfiguredComposite(this.stackContainer);
        if (BackendService.getInstance().isConfigured()) {
            this.showConfiguredMode();
            this.loadUsageAsync();
        } else {
            this.showNotConfiguredMode();
        }
        return this.stackContainer;
    }

    private void createConfiguredComposite(Composite parent) {
        this.configuredComposite = new Composite(parent, 0);
        this.configuredComposite.setLayout((Layout)new GridLayout(1, false));
        this.configuredComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createConnectionGroup(this.configuredComposite);
        this.createUsageGroup(this.configuredComposite);
    }

    private void createConnectionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createLabel((Composite)group, "\u0421\u0442\u0430\u0442\u0443\u0441:");
        this.statusLabel = new Label((Composite)group, 0);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u0421\u0435\u0440\u0432\u0435\u0440:");
        this.serverLabel = new Label((Composite)group, 0);
        this.serverLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c:");
        this.userEmailLabel = new Label((Composite)group, 0);
        this.userEmailLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite buttonRow = new Composite((Composite)group, 0);
        buttonRow.setLayout((Layout)new GridLayout(2, false));
        buttonRow.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        final Button rotateKeyButton = new Button(buttonRow, 8);
        rotateKeyButton.setText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043b\u044e\u0447");
        rotateKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.onRotateKey(rotateKeyButton);
            }
        });
        Button logoutButton = new Button(buttonRow, 8);
        logoutButton.setText("\u0412\u044b\u0439\u0442\u0438");
        logoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.onLogout();
            }
        });
        this.updateConnectionInfo();
    }

    private void createUsageGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435");
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createLabel((Composite)group, "\u0411\u044e\u0434\u0436\u0435\u0442:");
        this.budgetLabel = new Label((Composite)group, 0);
        this.budgetLabel.setText("...");
        this.budgetLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u041f\u043e\u0442\u0440\u0430\u0447\u0435\u043d\u043e:");
        this.spentLabel = new Label((Composite)group, 0);
        this.spentLabel.setText("...");
        this.spentLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u041e\u0441\u0442\u0430\u0442\u043e\u043a:");
        this.remainingLabel = new Label((Composite)group, 0);
        this.remainingLabel.setText("...");
        this.remainingLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.usageProgressBar = new ProgressBar((Composite)group, 65536);
        this.usageProgressBar.setMinimum(0);
        this.usageProgressBar.setMaximum(100);
        GridData progressData = new GridData(4, 0x1000000, true, false, 2, 1);
        progressData.heightHint = 16;
        this.usageProgressBar.setLayoutData((Object)progressData);
        this.createLabel((Composite)group, "\u0412\u0445\u043e\u0434\u043d\u044b\u0445 \u0442\u043e\u043a\u0435\u043d\u043e\u0432:");
        this.promptTokensLabel = new Label((Composite)group, 0);
        this.promptTokensLabel.setText("...");
        this.promptTokensLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u0412\u044b\u0445\u043e\u0434\u043d\u044b\u0445 \u0442\u043e\u043a\u0435\u043d\u043e\u0432:");
        this.completionTokensLabel = new Label((Composite)group, 0);
        this.completionTokensLabel.setText("...");
        this.completionTokensLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u0412\u0441\u0435\u0433\u043e \u0442\u043e\u043a\u0435\u043d\u043e\u0432:");
        this.totalTokensLabel = new Label((Composite)group, 0);
        this.totalTokensLabel.setText("...");
        this.totalTokensLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createLabel((Composite)group, "\u0421\u0431\u0440\u043e\u0441 \u0431\u044e\u0434\u0436\u0435\u0442\u0430:");
        this.resetDateLabel = new Label((Composite)group, 0);
        this.resetDateLabel.setText("...");
        this.resetDateLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button refreshButton = new Button((Composite)group, 8);
        refreshButton.setText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        refreshButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.loadUsageAsync();
            }
        });
    }

    private void createNotConfiguredComposite(Composite parent) {
        this.notConfiguredComposite = new Composite(parent, 0);
        this.notConfiguredComposite.setLayout((Layout)new GridLayout(1, false));
        this.notConfiguredComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label notConfiguredLabel = new Label(this.notConfiguredComposite, 64);
        notConfiguredLabel.setText("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.widthHint = 400;
        notConfiguredLabel.setLayoutData((Object)labelData);
        Button registerButton = new Button(this.notConfiguredComposite, 8);
        registerButton.setText("\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f");
        registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccountPreferencePage.this.onRegister();
            }
        });
    }

    private void showConfiguredMode() {
        this.stackLayout.topControl = this.configuredComposite;
        this.stackContainer.layout();
    }

    private void showNotConfiguredMode() {
        this.stackLayout.topControl = this.notConfiguredComposite;
        this.stackContainer.layout();
    }

    private void onRegister() {
        RegistrationResult result;
        RegistrationDialog dialog = new RegistrationDialog(this.getShell());
        if (dialog.open() == 0 && (result = dialog.getRegistrationResult()) != null && result.isSuccess()) {
            VibeCorePlugin.initializeLlmProvider((String)result.getApiKey());
            VibeStateService.getInstance().setIdle();
            this.updateConnectionInfo();
            this.showConfiguredMode();
            this.loadUsageAsync();
        }
    }

    private void onRotateKey(Button button) {
        button.setEnabled(false);
        button.setText("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435...");
        BackendService.getInstance().rotateKey().thenAccept(result -> {
            Display display;
            Display display2 = display = this.getControl() != null ? this.getControl().getDisplay() : Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> {
                    if (this.getControl() == null || this.getControl().isDisposed()) {
                        return;
                    }
                    button.setEnabled(true);
                    button.setText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043b\u044e\u0447");
                    if (result != null && result.isSuccess()) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"\u0423\u0441\u043f\u0435\u0445", (String)"\u041a\u043b\u044e\u0447 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d");
                    } else {
                        String error = result != null ? result.getError() : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
                        MessageDialog.openError((Shell)this.getShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043b\u044e\u0447: " + error));
                    }
                });
            }
        });
    }

    private void onLogout() {
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", (String)"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u044b\u0439\u0442\u0438? \u0414\u043b\u044f \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u043e\u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u0430\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f.");
        if (confirm) {
            BackendService.getInstance().clearCredentials();
            VibeStateService.getInstance().setNotConfigured("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f");
            this.showNotConfiguredMode();
        }
    }

    private void updateConnectionInfo() {
        BackendService service = BackendService.getInstance();
        if (this.statusLabel != null && !this.statusLabel.isDisposed()) {
            if (service.isConfigured()) {
                this.statusLabel.setText("\u25cf \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0451\u043d");
                this.statusLabel.setForeground(this.statusLabel.getDisplay().getSystemColor(6));
            } else {
                this.statusLabel.setText("\u25cf \u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0451\u043d");
                this.statusLabel.setForeground(this.statusLabel.getDisplay().getSystemColor(3));
            }
        }
        if (this.serverLabel != null && !this.serverLabel.isDisposed()) {
            this.serverLabel.setText(BackendConfig.BASE_URL);
        }
        if (this.userEmailLabel != null && !this.userEmailLabel.isDisposed()) {
            String userId = service.getUserId();
            this.userEmailLabel.setText(userId != null && !userId.isEmpty() ? userId : "\u2014");
        }
    }

    private void loadUsageAsync() {
        BackendService.getInstance().getUsage().thenAccept(usage -> {
            Display display;
            Display display2 = display = this.getControl() != null ? this.getControl().getDisplay() : Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> this.updateUsageDisplay((UsageInfo)usage));
            }
        });
    }

    private void updateUsageDisplay(UsageInfo usage) {
        if (this.getControl() == null || this.getControl().isDisposed() || usage == null) {
            return;
        }
        double percent = usage.getUsagePercent();
        if (this.budgetLabel != null && !this.budgetLabel.isDisposed()) {
            String duration = usage.getBudgetDuration() != null ? usage.getBudgetDuration() : "\u043c\u0435\u0441\u044f\u0446";
            this.budgetLabel.setText(String.format("$%.2f / %s", usage.getMaxBudget(), duration));
        }
        if (this.spentLabel != null && !this.spentLabel.isDisposed()) {
            this.spentLabel.setText(String.format("$%.2f (%.1f%%)", usage.getSpend(), percent));
        }
        if (this.remainingLabel != null && !this.remainingLabel.isDisposed()) {
            this.remainingLabel.setText(String.format("$%.2f", usage.getRemaining()));
        }
        if (this.usageProgressBar != null && !this.usageProgressBar.isDisposed()) {
            this.usageProgressBar.setSelection((int)Math.min(percent, 100.0));
            this.updateProgressBarColor(percent);
        }
        if (this.promptTokensLabel != null && !this.promptTokensLabel.isDisposed()) {
            this.promptTokensLabel.setText(NUMBER_FORMAT.format(usage.getPromptTokens()));
        }
        if (this.completionTokensLabel != null && !this.completionTokensLabel.isDisposed()) {
            this.completionTokensLabel.setText(NUMBER_FORMAT.format(usage.getCompletionTokens()));
        }
        if (this.totalTokensLabel != null && !this.totalTokensLabel.isDisposed()) {
            this.totalTokensLabel.setText(NUMBER_FORMAT.format(usage.getTotalTokens()));
        }
        if (this.resetDateLabel != null && !this.resetDateLabel.isDisposed()) {
            String resetDate = usage.getResetDate();
            this.resetDateLabel.setText(resetDate != null && !resetDate.isEmpty() ? resetDate : "\u2014");
        }
        this.configuredComposite.layout(true, true);
    }

    private void updateProgressBarColor(double percent) {
        if (this.usageProgressBar == null || this.usageProgressBar.isDisposed()) {
            return;
        }
        Display display = this.usageProgressBar.getDisplay();
        Color color = percent >= 90.0 ? display.getSystemColor(3) : (percent >= 70.0 ? display.getSystemColor(8) : display.getSystemColor(6));
        this.usageProgressBar.setForeground(color);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return label;
    }
}

