/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.statusbar;

import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.backend.UsageInfo;
import com.example.vibe.ui.internal.VibeUiPlugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BudgetStatusBarControl
extends ContributionItem
implements BackendService.UsageChangeListener {
    public static final String ID = "com.example.vibe.ui.budgetStatusbar";
    private Composite composite;
    private Label budgetLabel;

    public BudgetStatusBarControl() {
        super(ID);
    }

    public BudgetStatusBarControl(String id) {
        super(id);
    }

    public void fill(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 4;
        this.composite.setLayout((Layout)layout);
        StatusLineLayoutData layoutData = new StatusLineLayoutData();
        layoutData.widthHint = 100;
        this.composite.setLayoutData((Object)layoutData);
        this.budgetLabel = new Label(this.composite, 0);
        this.budgetLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.composite.addListener(3, e -> this.openAccountPreferences());
        this.budgetLabel.addListener(3, e -> this.openAccountPreferences());
        BackendService.getInstance().addUsageListener((BackendService.UsageChangeListener)this);
        this.updateFromUsage(BackendService.getInstance().getCachedUsage());
    }

    public void onUsageChanged(UsageInfo newUsage) {
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.updateFromUsage(newUsage);
                }
            });
        }
    }

    private void updateFromUsage(UsageInfo usage) {
        if (this.isDisposed()) {
            return;
        }
        if (!BackendService.getInstance().isConfigured() || usage == null) {
            this.budgetLabel.setText("");
            this.composite.setToolTipText(null);
            this.budgetLabel.setToolTipText(null);
            this.composite.layout(true);
            return;
        }
        String text = String.format("$%.2f/$%.2f", usage.getSpend(), usage.getMaxBudget());
        this.budgetLabel.setText(text);
        double percent = usage.getUsagePercent();
        Display display = this.composite.getDisplay();
        if (percent >= 90.0) {
            this.budgetLabel.setForeground(display.getSystemColor(3));
        } else if (percent >= 70.0) {
            this.budgetLabel.setForeground(display.getSystemColor(8));
        } else {
            this.budgetLabel.setForeground(display.getSystemColor(6));
        }
        String tooltip = this.buildTooltip(usage);
        this.composite.setToolTipText(tooltip);
        this.budgetLabel.setToolTipText(tooltip);
        this.composite.layout(true);
    }

    private String buildTooltip(UsageInfo usage) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u0411\u044e\u0434\u0436\u0435\u0442 AI-\u0441\u0435\u0440\u0432\u0438\u0441\u0430\n");
        sb.append(String.format("\u041f\u043e\u0442\u0440\u0430\u0447\u0435\u043d\u043e: $%.2f / $%.2f (%.1f%%)\n", usage.getSpend(), usage.getMaxBudget(), usage.getUsagePercent()));
        sb.append(String.format("\u041e\u0441\u0442\u0430\u0442\u043e\u043a: $%.2f\n", usage.getRemaining()));
        sb.append(String.format("\u0422\u043e\u043a\u0435\u043d\u044b: %d (\u0432\u0445: %d, \u0432\u044b\u0445: %d)", usage.getTotalTokens(), usage.getPromptTokens(), usage.getCompletionTokens()));
        String resetDate = usage.getResetDate();
        if (resetDate != null && !resetDate.isEmpty()) {
            sb.append(String.format("\n\u0421\u0431\u0440\u043e\u0441: %s", resetDate));
        }
        return sb.toString();
    }

    private void openAccountPreferences() {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                PreferencesUtil.createPreferenceDialogOn((Shell)window.getShell(), (String)"com.example.vibe.ui.preferences.AccountPreferencePage", null, null).open();
            }
        }
        catch (Exception e) {
            VibeUiPlugin.log(e);
        }
    }

    private boolean isDisposed() {
        return this.composite == null || this.composite.isDisposed();
    }

    public void dispose() {
        BackendService.getInstance().removeUsageListener((BackendService.UsageChangeListener)this);
        super.dispose();
    }
}

