/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.theme;

import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

class DarkTheme
implements VibeTheme {
    private final ThemeManager manager;
    private static final RGB BACKGROUND = new RGB(11, 18, 32);
    private static final RGB SURFACE = new RGB(17, 24, 39);
    private static final RGB SURFACE_ELEVATED = new RGB(31, 41, 55);
    private static final RGB INPUT_BG = new RGB(17, 24, 39);
    private static final RGB TEXT = new RGB(229, 231, 235);
    private static final RGB TEXT_MUTED = new RGB(148, 163, 184);
    private static final RGB TEXT_INVERTED = new RGB(15, 23, 42);
    private static final RGB BORDER = new RGB(36, 50, 68);
    private static final RGB BORDER_SUBTLE = new RGB(31, 41, 55);
    private static final RGB BORDER_FOCUS = new RGB(96, 165, 250);
    private static final RGB ACCENT = new RGB(96, 165, 250);
    private static final RGB ACCENT_HOVER = new RGB(147, 197, 253);
    private static final RGB SUCCESS = new RGB(34, 197, 94);
    private static final RGB WARNING = new RGB(245, 158, 11);
    private static final RGB DANGER = new RGB(248, 113, 113);
    private static final RGB USER_MSG_BG = new RGB(30, 41, 59);
    private static final RGB ASSISTANT_MSG_BG = new RGB(17, 24, 39);
    private static final RGB SYSTEM_MSG_BG = new RGB(30, 27, 20);
    private static final RGB TOOL_CALL_BG = new RGB(20, 30, 26);
    private static final RGB TOOL_RESULT_BG = new RGB(31, 41, 55);
    private static final RGB CODE_BG = new RGB(15, 23, 42);
    private static final RGB INLINE_CODE_BG = new RGB(30, 41, 59);
    private static final RGB CODE_TEXT = new RGB(226, 232, 240);
    private static final RGB DIFF_ADDED = new RGB(20, 50, 35);
    private static final RGB DIFF_REMOVED = new RGB(50, 20, 20);
    private static final RGB DIFF_CHANGED = new RGB(50, 45, 15);

    DarkTheme(ThemeManager manager) {
        this.manager = manager;
    }

    @Override
    public Color getBackground() {
        return this.manager.getColor("dark.background", BACKGROUND);
    }

    @Override
    public Color getSurface() {
        return this.manager.getColor("dark.surface", SURFACE);
    }

    @Override
    public Color getSurfaceElevated() {
        return this.manager.getColor("dark.surface.elevated", SURFACE_ELEVATED);
    }

    @Override
    public Color getInputBackground() {
        return this.manager.getColor("dark.input.bg", INPUT_BG);
    }

    @Override
    public Color getText() {
        return this.manager.getColor("dark.text", TEXT);
    }

    @Override
    public Color getTextMuted() {
        return this.manager.getColor("dark.text.muted", TEXT_MUTED);
    }

    @Override
    public Color getTextInverted() {
        return this.manager.getColor("dark.text.inverted", TEXT_INVERTED);
    }

    @Override
    public Color getBorder() {
        return this.manager.getColor("dark.border", BORDER);
    }

    @Override
    public Color getBorderSubtle() {
        return this.manager.getColor("dark.border.subtle", BORDER_SUBTLE);
    }

    @Override
    public Color getBorderFocus() {
        return this.manager.getColor("dark.border.focus", BORDER_FOCUS);
    }

    @Override
    public Color getAccent() {
        return this.manager.getColor("dark.accent", ACCENT);
    }

    @Override
    public Color getAccentHover() {
        return this.manager.getColor("dark.accent.hover", ACCENT_HOVER);
    }

    @Override
    public Color getSuccess() {
        return this.manager.getColor("dark.success", SUCCESS);
    }

    @Override
    public Color getWarning() {
        return this.manager.getColor("dark.warning", WARNING);
    }

    @Override
    public Color getDanger() {
        return this.manager.getColor("dark.danger", DANGER);
    }

    @Override
    public Color getUserMessageBackground() {
        return this.manager.getColor("dark.chat.user", USER_MSG_BG);
    }

    @Override
    public Color getAssistantMessageBackground() {
        return this.manager.getColor("dark.chat.assistant", ASSISTANT_MSG_BG);
    }

    @Override
    public Color getSystemMessageBackground() {
        return this.manager.getColor("dark.chat.system", SYSTEM_MSG_BG);
    }

    @Override
    public Color getToolCallBackground() {
        return this.manager.getColor("dark.chat.tool.call", TOOL_CALL_BG);
    }

    @Override
    public Color getToolResultBackground() {
        return this.manager.getColor("dark.chat.tool.result", TOOL_RESULT_BG);
    }

    @Override
    public Color getCodeBackground() {
        return this.manager.getColor("dark.code.bg", CODE_BG);
    }

    @Override
    public Color getInlineCodeBackground() {
        return this.manager.getColor("dark.code.inline.bg", INLINE_CODE_BG);
    }

    @Override
    public Color getCodeText() {
        return this.manager.getColor("dark.code.text", CODE_TEXT);
    }

    @Override
    public Color getDiffAddedBackground() {
        return this.manager.getColor("dark.diff.added", DIFF_ADDED);
    }

    @Override
    public Color getDiffRemovedBackground() {
        return this.manager.getColor("dark.diff.removed", DIFF_REMOVED);
    }

    @Override
    public Color getDiffChangedBackground() {
        return this.manager.getColor("dark.diff.changed", DIFF_CHANGED);
    }

    @Override
    public Font getFont() {
        return this.manager.getFont("font.default", this.manager.getBaseFontName(), this.manager.getBaseFontHeight(), 0);
    }

    @Override
    public Font getFontBold() {
        return this.manager.getFont("font.bold", this.manager.getBaseFontName(), this.manager.getBaseFontHeight(), 1);
    }

    @Override
    public Font getFontItalic() {
        return this.manager.getFont("font.italic", this.manager.getBaseFontName(), this.manager.getBaseFontHeight(), 2);
    }

    @Override
    public Font getFontMono() {
        return this.manager.getFont("font.mono", this.manager.getMonoFontName(), this.manager.getBaseFontHeight(), 0);
    }

    @Override
    public Font getFontMonoBold() {
        return this.manager.getFont("font.mono.bold", this.manager.getMonoFontName(), this.manager.getBaseFontHeight(), 1);
    }

    @Override
    public Font getFontHeader() {
        return this.manager.getFont("font.header", this.manager.getBaseFontName(), this.manager.getBaseFontHeight() + 2, 1);
    }

    @Override
    public Font getFontSmall() {
        return this.manager.getFont("font.small", this.manager.getBaseFontName(), Math.max(this.manager.getBaseFontHeight() - 2, 8), 0);
    }

    @Override
    public int getMargin() {
        return 8;
    }

    @Override
    public int getMarginSmall() {
        return 4;
    }

    @Override
    public int getMarginLarge() {
        return 16;
    }

    @Override
    public int getPadding() {
        return 12;
    }

    @Override
    public int getBorderRadius() {
        return 8;
    }

    @Override
    public boolean isDark() {
        return true;
    }

    @Override
    public String getName() {
        return "Vibe Dark";
    }

    @Override
    public Color withAlpha(Color base, float alpha) {
        RGB bg = BACKGROUND;
        int r = Math.round((float)base.getRed() * alpha + (float)bg.red * (1.0f - alpha));
        int g = Math.round((float)base.getGreen() * alpha + (float)bg.green * (1.0f - alpha));
        int b = Math.round((float)base.getBlue() * alpha + (float)bg.blue * (1.0f - alpha));
        return this.manager.getColor("blend." + base.hashCode() + "." + alpha, new RGB(r, g, b));
    }

    @Override
    public RGB getRGB(String token) {
        switch (token) {
            case "background": {
                return BACKGROUND;
            }
            case "surface": {
                return SURFACE;
            }
            case "text": {
                return TEXT;
            }
            case "text.muted": {
                return TEXT_MUTED;
            }
            case "border": {
                return BORDER;
            }
            case "accent": {
                return ACCENT;
            }
            case "success": {
                return SUCCESS;
            }
            case "warning": {
                return WARNING;
            }
            case "danger": {
                return DANGER;
            }
            case "code.bg": {
                return CODE_BG;
            }
        }
        return null;
    }
}

