/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.theme;

import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

class LightTheme
implements VibeTheme {
    private final ThemeManager manager;
    private static final RGB BACKGROUND = new RGB(248, 250, 252);
    private static final RGB SURFACE = new RGB(255, 255, 255);
    private static final RGB SURFACE_ELEVATED = new RGB(241, 245, 249);
    private static final RGB INPUT_BG = new RGB(255, 255, 255);
    private static final RGB TEXT = new RGB(15, 23, 42);
    private static final RGB TEXT_MUTED = new RGB(100, 116, 139);
    private static final RGB TEXT_INVERTED = new RGB(255, 255, 255);
    private static final RGB BORDER = new RGB(226, 232, 240);
    private static final RGB BORDER_SUBTLE = new RGB(241, 245, 249);
    private static final RGB BORDER_FOCUS = new RGB(59, 130, 246);
    private static final RGB ACCENT = new RGB(37, 99, 235);
    private static final RGB ACCENT_HOVER = new RGB(29, 78, 216);
    private static final RGB SUCCESS = new RGB(22, 163, 74);
    private static final RGB WARNING = new RGB(217, 119, 6);
    private static final RGB DANGER = new RGB(220, 38, 38);
    private static final RGB USER_MSG_BG = new RGB(239, 246, 255);
    private static final RGB ASSISTANT_MSG_BG = new RGB(255, 255, 255);
    private static final RGB SYSTEM_MSG_BG = new RGB(254, 252, 232);
    private static final RGB TOOL_CALL_BG = new RGB(240, 253, 244);
    private static final RGB TOOL_RESULT_BG = new RGB(241, 245, 249);
    private static final RGB CODE_BG = new RGB(248, 250, 252);
    private static final RGB INLINE_CODE_BG = new RGB(241, 245, 249);
    private static final RGB CODE_TEXT = new RGB(51, 65, 85);
    private static final RGB DIFF_ADDED = new RGB(220, 252, 231);
    private static final RGB DIFF_REMOVED = new RGB(254, 226, 226);
    private static final RGB DIFF_CHANGED = new RGB(254, 249, 195);

    LightTheme(ThemeManager manager) {
        this.manager = manager;
    }

    @Override
    public Color getBackground() {
        return this.manager.getColor("light.background", BACKGROUND);
    }

    @Override
    public Color getSurface() {
        return this.manager.getColor("light.surface", SURFACE);
    }

    @Override
    public Color getSurfaceElevated() {
        return this.manager.getColor("light.surface.elevated", SURFACE_ELEVATED);
    }

    @Override
    public Color getInputBackground() {
        return this.manager.getColor("light.input.bg", INPUT_BG);
    }

    @Override
    public Color getText() {
        return this.manager.getColor("light.text", TEXT);
    }

    @Override
    public Color getTextMuted() {
        return this.manager.getColor("light.text.muted", TEXT_MUTED);
    }

    @Override
    public Color getTextInverted() {
        return this.manager.getColor("light.text.inverted", TEXT_INVERTED);
    }

    @Override
    public Color getBorder() {
        return this.manager.getColor("light.border", BORDER);
    }

    @Override
    public Color getBorderSubtle() {
        return this.manager.getColor("light.border.subtle", BORDER_SUBTLE);
    }

    @Override
    public Color getBorderFocus() {
        return this.manager.getColor("light.border.focus", BORDER_FOCUS);
    }

    @Override
    public Color getAccent() {
        return this.manager.getColor("light.accent", ACCENT);
    }

    @Override
    public Color getAccentHover() {
        return this.manager.getColor("light.accent.hover", ACCENT_HOVER);
    }

    @Override
    public Color getSuccess() {
        return this.manager.getColor("light.success", SUCCESS);
    }

    @Override
    public Color getWarning() {
        return this.manager.getColor("light.warning", WARNING);
    }

    @Override
    public Color getDanger() {
        return this.manager.getColor("light.danger", DANGER);
    }

    @Override
    public Color getUserMessageBackground() {
        return this.manager.getColor("light.chat.user", USER_MSG_BG);
    }

    @Override
    public Color getAssistantMessageBackground() {
        return this.manager.getColor("light.chat.assistant", ASSISTANT_MSG_BG);
    }

    @Override
    public Color getSystemMessageBackground() {
        return this.manager.getColor("light.chat.system", SYSTEM_MSG_BG);
    }

    @Override
    public Color getToolCallBackground() {
        return this.manager.getColor("light.chat.tool.call", TOOL_CALL_BG);
    }

    @Override
    public Color getToolResultBackground() {
        return this.manager.getColor("light.chat.tool.result", TOOL_RESULT_BG);
    }

    @Override
    public Color getCodeBackground() {
        return this.manager.getColor("light.code.bg", CODE_BG);
    }

    @Override
    public Color getInlineCodeBackground() {
        return this.manager.getColor("light.code.inline.bg", INLINE_CODE_BG);
    }

    @Override
    public Color getCodeText() {
        return this.manager.getColor("light.code.text", CODE_TEXT);
    }

    @Override
    public Color getDiffAddedBackground() {
        return this.manager.getColor("light.diff.added", DIFF_ADDED);
    }

    @Override
    public Color getDiffRemovedBackground() {
        return this.manager.getColor("light.diff.removed", DIFF_REMOVED);
    }

    @Override
    public Color getDiffChangedBackground() {
        return this.manager.getColor("light.diff.changed", DIFF_CHANGED);
    }

    @Override
    public Font getFont() {
        return this.manager.getFont("font.default", this.manager.getBaseFontName(), this.manager.getBaseFontHeight(), 0);
    }

    @Override
    public Font getFontBold() {
        return this.manager.getFont("font.bold", this.manager.getBaseFontName(), this.manager.getBaseFontHeight(), 1);
    }

    @Override
    public Font getFontItalic() {
        return this.manager.getFont("font.italic", this.manager.getBaseFontName(), this.manager.getBaseFontHeight(), 2);
    }

    @Override
    public Font getFontMono() {
        return this.manager.getFont("font.mono", this.manager.getMonoFontName(), this.manager.getBaseFontHeight(), 0);
    }

    @Override
    public Font getFontMonoBold() {
        return this.manager.getFont("font.mono.bold", this.manager.getMonoFontName(), this.manager.getBaseFontHeight(), 1);
    }

    @Override
    public Font getFontHeader() {
        return this.manager.getFont("font.header", this.manager.getBaseFontName(), this.manager.getBaseFontHeight() + 2, 1);
    }

    @Override
    public Font getFontSmall() {
        return this.manager.getFont("font.small", this.manager.getBaseFontName(), Math.max(this.manager.getBaseFontHeight() - 2, 8), 0);
    }

    @Override
    public int getMargin() {
        return 8;
    }

    @Override
    public int getMarginSmall() {
        return 4;
    }

    @Override
    public int getMarginLarge() {
        return 16;
    }

    @Override
    public int getPadding() {
        return 12;
    }

    @Override
    public int getBorderRadius() {
        return 8;
    }

    @Override
    public boolean isDark() {
        return false;
    }

    @Override
    public String getName() {
        return "Vibe Light";
    }

    @Override
    public Color withAlpha(Color base, float alpha) {
        RGB bg = BACKGROUND;
        int r = Math.round((float)base.getRed() * alpha + (float)bg.red * (1.0f - alpha));
        int g = Math.round((float)base.getGreen() * alpha + (float)bg.green * (1.0f - alpha));
        int b = Math.round((float)base.getBlue() * alpha + (float)bg.blue * (1.0f - alpha));
        return this.manager.getColor("blend." + base.hashCode() + "." + alpha, new RGB(r, g, b));
    }

    @Override
    public RGB getRGB(String token) {
        switch (token) {
            case "background": {
                return BACKGROUND;
            }
            case "surface": {
                return SURFACE;
            }
            case "text": {
                return TEXT;
            }
            case "text.muted": {
                return TEXT_MUTED;
            }
            case "border": {
                return BORDER;
            }
            case "accent": {
                return ACCENT;
            }
            case "success": {
                return SUCCESS;
            }
            case "warning": {
                return WARNING;
            }
            case "danger": {
                return DANGER;
            }
            case "code.bg": {
                return CODE_BG;
            }
        }
        return null;
    }
}

