/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.core.agent.AgentResult;
import com.example.vibe.core.agent.AgentState;
import com.example.vibe.core.agent.profiles.AgentProfile;
import com.example.vibe.core.agent.profiles.AgentProfileRegistry;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.provider.LlmProviderException;
import com.example.vibe.core.provider.LlmProviderRegistry;
import com.example.vibe.core.state.VibeStateService;
import com.example.vibe.ui.chat.AgentProgressWidget;
import com.example.vibe.ui.chat.AgentViewAdapter;
import com.example.vibe.ui.views.ChatMessageComposite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class AgentView
extends ViewPart {
    public static final String ID = "com.example.vibe.ui.views.AgentView";
    private ScrolledComposite scrolledComposite;
    private Composite messagesContainer;
    private Text inputField;
    private Button sendButton;
    private Button stopButton;
    private Button clearButton;
    private Combo profileCombo;
    private AgentProgressWidget progressWidget;
    private final List<ChatMessageComposite> messageWidgets = new ArrayList<ChatMessageComposite>();
    private AgentViewAdapter agentAdapter;
    private CompletableFuture<AgentResult> currentTask;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createProgressArea(container);
        this.createChatArea(container);
        this.createInputArea(container);
        this.agentAdapter = new AgentViewAdapter(parent.getDisplay());
        this.setupAdapterCallbacks();
        this.appendSystemMessage("\ud83e\udd16 \u0410\u0433\u0435\u043d\u0442\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0433\u043e\u0442\u043e\u0432. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443.");
    }

    private void createProgressArea(Composite parent) {
        this.progressWidget = new AgentProgressWidget(parent);
        this.progressWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
    }

    private void createChatArea(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 2560);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.messagesContainer = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 8;
        this.messagesContainer.setLayout((Layout)layout);
        this.scrolledComposite.setContent((Control)this.messagesContainer);
        this.messagesContainer.addListener(11, e -> this.updateScrollSize());
    }

    private void createInputArea(Composite parent) {
        Composite inputArea = new Composite(parent, 0);
        inputArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout inputLayout = new GridLayout(1, false);
        inputLayout.marginWidth = 8;
        inputLayout.marginHeight = 8;
        inputLayout.verticalSpacing = 8;
        inputArea.setLayout((Layout)inputLayout);
        Composite topRow = new Composite(inputArea, 0);
        topRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout topLayout = new GridLayout(3, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topRow.setLayout((Layout)topLayout);
        Label profileLabel = new Label(topRow, 0);
        profileLabel.setText("\u041f\u0440\u043e\u0444\u0438\u043b\u044c:");
        profileLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.profileCombo = new Combo(topRow, 12);
        this.profileCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.populateProfileCombo();
        Label spacer = new Label(topRow, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.inputField = new Text(inputArea, 2626);
        GridData inputData = new GridData(4, 4, true, false);
        inputData.heightHint = 80;
        this.inputField.setLayoutData((Object)inputData);
        this.inputField.setMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443 \u0434\u043b\u044f \u0430\u0433\u0435\u043d\u0442\u0430 (Ctrl+Enter \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438)...");
        this.inputField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 && (e.stateMask & 0x40000) != 0) {
                    AgentView.this.runAgent();
                }
            }
        });
        Composite buttonBar = new Composite(inputArea, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout buttonLayout = new GridLayout(4, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonLayout.horizontalSpacing = 8;
        buttonBar.setLayout((Layout)buttonLayout);
        this.sendButton = new Button(buttonBar, 8);
        this.sendButton.setText("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c");
        this.sendButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sendButton.addListener(13, e -> this.runAgent());
        Label btnSpacer = new Label(buttonBar, 0);
        btnSpacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stopButton = new Button(buttonBar, 8);
        this.stopButton.setText("\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        this.stopButton.setEnabled(false);
        this.stopButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.stopButton.addListener(13, e -> this.stopAgent());
        this.clearButton = new Button(buttonBar, 8);
        this.clearButton.setText("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        this.clearButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.clearButton.addListener(13, e -> this.clearChat());
    }

    private void populateProfileCombo() {
        for (AgentProfile profile : AgentProfileRegistry.getInstance().getAllProfiles()) {
            String displayName = String.format("%s - %s", profile.getName(), profile.isReadOnly() ? "\u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u0435\u043d\u0438\u0435" : "\u043f\u043e\u043b\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f");
            this.profileCombo.add(displayName);
            this.profileCombo.setData(displayName, (Object)profile.getId());
        }
        this.profileCombo.select(0);
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentView.this.updateProfileTooltip();
            }
        });
        this.updateProfileTooltip();
    }

    private void updateProfileTooltip() {
        int idx = this.profileCombo.getSelectionIndex();
        if (idx >= 0) {
            String displayName = this.profileCombo.getItem(idx);
            String profileId = (String)this.profileCombo.getData(displayName);
            AgentProfileRegistry.getInstance().getProfile(profileId).ifPresent(profile -> {
                String tooltip = String.format("%s\n\n\u041c\u0430\u043a\u0441. \u0448\u0430\u0433\u043e\u0432: %d\n\u0422\u0430\u0439\u043c\u0430\u0443\u0442: %d \u0441\u0435\u043a\n\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b: %s", profile.getDescription(), profile.getMaxSteps(), profile.getTimeoutMs() / 1000L, String.join((CharSequence)", ", profile.getAllowedTools()));
                this.profileCombo.setToolTipText(tooltip);
            });
        }
    }

    private void setupAdapterCallbacks() {
        this.agentAdapter.setMessageAppender(new AgentViewAdapter.MessageAppender(){

            @Override
            public void appendSystemMessage(String message) {
                AgentView.this.appendSystemMessage(message);
            }

            @Override
            public void appendAssistantMessage(String message) {
                AgentView.this.appendAssistantMessage(message);
            }

            @Override
            public void appendToolMessage(String message) {
                AgentView.this.appendMessage("\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442", message, false);
            }

            @Override
            public void updateStreamingMessage(String messageId, String content) {
            }
        });
        this.agentAdapter.setProgressUpdater((current, max, status) -> {
            if (this.progressWidget != null && !this.progressWidget.isDisposed()) {
                this.progressWidget.updateProgress(current, max, status);
            }
        });
        this.agentAdapter.setStateChangeListener((newState, errorMessage) -> {
            if (this.progressWidget != null && !this.progressWidget.isDisposed()) {
                this.progressWidget.updateState(newState, errorMessage);
            }
            boolean isRunning = newState == AgentState.RUNNING || newState == AgentState.WAITING_TOOL || newState == AgentState.WAITING_CONFIRMATION;
            this.setProcessing(isRunning);
        });
    }

    private void runAgent() {
        String prompt = this.inputField.getText().trim();
        if (prompt.isEmpty()) {
            return;
        }
        ILlmProvider provider = LlmProviderRegistry.getInstance().getActiveProvider();
        if (provider == null || !provider.isConfigured()) {
            this.appendSystemMessage("\u274c LLM \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d. \u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438.");
            return;
        }
        int idx = this.profileCombo.getSelectionIndex();
        String profileId = "build";
        if (idx >= 0) {
            String displayName = this.profileCombo.getItem(idx);
            profileId = (String)this.profileCombo.getData(displayName);
        }
        this.appendUserMessage(prompt);
        this.inputField.setText("");
        this.setProcessing(true);
        String finalProfileId = profileId;
        this.currentTask = this.agentAdapter.run(prompt, finalProfileId).whenComplete((result, error) -> Display.getDefault().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.setProcessing(false);
                if (error != null) {
                    this.handleAgentError((Throwable)error);
                }
            }
        }));
    }

    private void handleAgentError(Throwable error) {
        Throwable cause;
        Throwable throwable = cause = error.getCause() != null ? error.getCause() : error;
        if (cause instanceof LlmProviderException) {
            LlmProviderException lpe = (LlmProviderException)cause;
            if (lpe.isBudgetExceeded()) {
                this.appendSystemMessage("\u0411\u044e\u0434\u0436\u0435\u0442 \u0438\u0441\u0447\u0435\u0440\u043f\u0430\u043d. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443 \u0438\u043b\u0438 \u0434\u043e\u0436\u0434\u0438\u0442\u0435\u0441\u044c \u0441\u0431\u0440\u043e\u0441\u0430.");
                VibeStateService.getInstance().setBudgetExceeded("\u0411\u044e\u0434\u0436\u0435\u0442 \u0438\u0441\u0447\u0435\u0440\u043f\u0430\u043d");
                return;
            }
            if (lpe.isRateLimitError()) {
                this.appendSystemMessage("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432. \u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 \u043d\u0435\u043c\u043d\u043e\u0433\u043e.");
                return;
            }
            if (lpe.isAuthenticationError()) {
                this.appendSystemMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
                return;
            }
        }
        this.appendSystemMessage("\u041e\u0448\u0438\u0431\u043a\u0430: " + cause.getMessage());
    }

    private void stopAgent() {
        if (this.agentAdapter != null) {
            this.agentAdapter.cancel();
        }
        if (this.currentTask != null && !this.currentTask.isDone()) {
            this.currentTask.cancel(true);
        }
        this.setProcessing(false);
    }

    private void clearChat() {
        for (ChatMessageComposite widget : this.messageWidgets) {
            if (widget.isDisposed()) continue;
            widget.dispose();
        }
        this.messageWidgets.clear();
        Control[] controlArray = this.messagesContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!child.isDisposed()) {
                child.dispose();
            }
            ++n2;
        }
        this.messagesContainer.layout(true, true);
        this.updateScrollSize();
        if (this.progressWidget != null && !this.progressWidget.isDisposed()) {
            this.progressWidget.reset();
        }
        this.appendSystemMessage("\ud83e\udd16 \u0427\u0430\u0442 \u043e\u0447\u0438\u0449\u0435\u043d. \u0413\u043e\u0442\u043e\u0432 \u043a \u043d\u043e\u0432\u044b\u043c \u0437\u0430\u0434\u0430\u0447\u0430\u043c.");
    }

    private void setProcessing(boolean processing) {
        if (!this.isDisposed()) {
            this.sendButton.setEnabled(!processing);
            this.stopButton.setEnabled(processing);
            this.inputField.setEnabled(!processing);
            this.profileCombo.setEnabled(!processing);
        }
    }

    private void appendUserMessage(String message) {
        this.appendMessage("\u0412\u044b", message, false);
    }

    private void appendAssistantMessage(String message) {
        this.appendMessage("\u0410\u0433\u0435\u043d\u0442", message, true);
    }

    private void appendSystemMessage(String message) {
        this.appendMessage("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", message, false);
    }

    private void appendMessage(String sender, String message, boolean isAssistant) {
        if (this.messagesContainer == null || this.messagesContainer.isDisposed()) {
            return;
        }
        ChatMessageComposite messageWidget = new ChatMessageComposite(this.messagesContainer, sender, message, isAssistant);
        messageWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.messageWidgets.add(messageWidget);
        this.messagesContainer.layout(true, true);
        this.updateScrollSize();
        this.scrollToBottom();
    }

    private void updateScrollSize() {
        if (this.messagesContainer != null && !this.messagesContainer.isDisposed()) {
            this.messagesContainer.setSize(this.messagesContainer.computeSize(this.scrolledComposite.getClientArea().width, -1));
        }
    }

    private void scrollToBottom() {
        if (this.scrolledComposite != null && !this.scrolledComposite.isDisposed()) {
            this.scrolledComposite.getDisplay().asyncExec(() -> {
                if (!this.scrolledComposite.isDisposed() && !this.messagesContainer.isDisposed()) {
                    this.scrolledComposite.setOrigin(0, this.messagesContainer.getSize().y);
                }
            });
        }
    }

    private boolean isDisposed() {
        return this.scrolledComposite == null || this.scrolledComposite.isDisposed();
    }

    public CompletableFuture<AgentResult> runProgrammatic(String prompt, String profileId) {
        this.inputField.setText(prompt);
        int i = 0;
        while (i < this.profileCombo.getItemCount()) {
            String displayName = this.profileCombo.getItem(i);
            String id = (String)this.profileCombo.getData(displayName);
            if (profileId.equals(id)) {
                this.profileCombo.select(i);
                break;
            }
            ++i;
        }
        this.runAgent();
        return this.currentTask;
    }

    public void setFocus() {
        this.inputField.setFocus();
    }

    public void dispose() {
        this.stopAgent();
        if (this.agentAdapter != null) {
            this.agentAdapter.dispose();
            this.agentAdapter = null;
        }
        for (ChatMessageComposite widget : this.messageWidgets) {
            if (widget.isDisposed()) continue;
            widget.dispose();
        }
        this.messageWidgets.clear();
        super.dispose();
    }
}

