/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.internal.VibeUiPlugin;
import com.example.vibe.ui.markdown.SimpleMarkdownParser;
import com.example.vibe.ui.theme.ThemeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class BrowserMessageComposite
extends Composite {
    private static final String CSS_RESOURCE = "/resources/chat.css";
    private static final String JS_RESOURCE = "/resources/chat.js";
    private static String cachedCss;
    private static String cachedJs;
    private final Browser browser;
    private final SimpleMarkdownParser markdownParser;
    private final String sender;
    private final String message;
    private final boolean isAssistant;
    private BrowserFunction copyFunction;
    private BrowserFunction openUrlFunction;

    public BrowserMessageComposite(Composite parent, String sender, String message, boolean isAssistant) {
        super(parent, 0);
        this.sender = sender;
        this.message = message != null ? message : "";
        this.isAssistant = isAssistant;
        this.markdownParser = new SimpleMarkdownParser();
        this.setLayout((Layout)new FillLayout());
        Browser tempBrowser = null;
        try {
            tempBrowser = new Browser((Composite)this, 262144);
        }
        catch (SWTError sWTError) {
            try {
                tempBrowser = new Browser((Composite)this, 0);
            }
            catch (SWTError e2) {
                VibeUiPlugin.log(e2);
            }
        }
        this.browser = tempBrowser;
        if (this.browser != null) {
            this.setupBrowser();
            this.renderMessage();
        }
    }

    private void setupBrowser() {
        this.browser.addMenuDetectListener(e -> {
            boolean bl = e.doit = false;
        });
        this.copyFunction = new BrowserFunction(this.browser, "copyToClipboard"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0 && arguments[0] instanceof String) {
                    String text = (String)arguments[0];
                    BrowserMessageComposite.this.copyToClipboard(text);
                }
                return null;
            }
        };
        this.openUrlFunction = new BrowserFunction(this.browser, "openUrl"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0 && arguments[0] instanceof String) {
                    String url = (String)arguments[0];
                    BrowserMessageComposite.this.openExternalUrl(url);
                }
                return null;
            }
        };
    }

    private void renderMessage() {
        String html = this.buildHtmlDocument();
        this.browser.setText(html);
    }

    private String buildHtmlDocument() {
        String css = this.loadCss();
        String js = this.loadJs();
        String themeClass = ThemeManager.getInstance().isDarkTheme() ? "dark" : "light";
        String messageClass = this.isAssistant ? "assistant" : "user";
        String messageHtml = this.markdownParser.toHtml(this.message);
        return "<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <style>\n" + css + "\n    </style>\n</head>\n<body class=\"" + themeClass + "\">\n    <div class=\"message-container\">\n        <div class=\"message " + messageClass + "\">\n            <div class=\"message-header\">\n                <span class=\"message-sender\">" + this.escapeHtml(this.sender) + "</span>\n            </div>\n            <div class=\"message-content\">\n" + messageHtml + "\n            </div>\n        </div>\n    </div>\n    <script>\n" + js + "\n    </script>\n</body>\n</html>";
    }

    private String loadCss() {
        if (cachedCss != null) {
            return cachedCss;
        }
        cachedCss = this.loadResource(CSS_RESOURCE);
        if (cachedCss == null) {
            cachedCss = this.getDefaultCss();
        }
        return cachedCss;
    }

    private String loadJs() {
        if (cachedJs != null) {
            return cachedJs;
        }
        cachedJs = this.loadResource(JS_RESOURCE);
        if (cachedJs == null) {
            cachedJs = this.getDefaultJs();
        }
        return cachedJs;
    }

    /*
     * Loose catch block
     */
    private String loadResource(String path) {
        block17: {
            try {
                URL url = VibeUiPlugin.getDefault().getBundle().getEntry(path);
                if (url == null) break block17;
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    String string;
                    BufferedReader reader;
                    InputStream is;
                    block19: {
                        block18: {
                            is = url.openStream();
                            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                            string = reader.lines().collect(Collectors.joining("\n"));
                            if (reader == null) break block18;
                            reader.close();
                        }
                        if (is == null) break block19;
                        is.close();
                    }
                    return string;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                VibeUiPlugin.log(e);
            }
        }
        return null;
    }

    private String getDefaultCss() {
        return "body {\n    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;\n    font-size: 14px;\n    line-height: 1.6;\n    margin: 0;\n    padding: 12px;\n    background: #ffffff;\n    color: #1a1a2e;\n}\nbody.dark {\n    background: #1e293b;\n    color: #f1f5f9;\n}\ntable {\n    border-collapse: collapse;\n    width: 100%;\n    margin: 12px 0;\n}\nth, td {\n    border: 1px solid #e2e8f0;\n    padding: 8px 12px;\n    text-align: left;\n}\nbody.dark th, body.dark td {\n    border-color: #334155;\n}\npre {\n    background: #f1f5f9;\n    padding: 12px;\n    border-radius: 6px;\n    overflow-x: auto;\n}\nbody.dark pre {\n    background: #0f172a;\n}\ncode {\n    font-family: 'Consolas', 'Monaco', monospace;\n    font-size: 13px;\n}\n";
    }

    private String getDefaultJs() {
        return "function copyCode(button) {\n    var codeBlock = button.closest('.code-block');\n    var code = codeBlock.querySelector('pre code');\n    var text = code.textContent || code.innerText;\n    if (typeof copyToClipboard === 'function') {\n        copyToClipboard(text);\n    }\n    button.textContent = '\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u043e!';\n    setTimeout(function() { button.textContent = '\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c'; }, 2000);\n}\n";
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private void copyToClipboard(String text) {
        Display.getDefault().asyncExec(() -> {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        });
    }

    private void openExternalUrl(String url) {
        Display.getDefault().asyncExec(() -> Program.launch((String)url));
    }

    public void updateTheme(boolean isDark) {
        if (this.browser != null && !this.browser.isDisposed()) {
            String themeClass = isDark ? "dark" : "light";
            this.browser.execute("document.body.className = '" + themeClass + "';");
        }
    }

    public boolean isBrowserAvailable() {
        return this.browser != null && !this.browser.isDisposed();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void dispose() {
        if (this.copyFunction != null) {
            this.copyFunction.dispose();
        }
        if (this.openUrlFunction != null) {
            this.openUrlFunction.dispose();
        }
        super.dispose();
    }
}

