/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.chat.ChatMessage;
import com.example.vibe.ui.chat.MessageContentParser;
import com.example.vibe.ui.chat.MessageKind;
import com.example.vibe.ui.chat.MessagePart;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import com.example.vibe.ui.views.CodeBlockWidget;
import com.example.vibe.ui.views.TodoListWidget;
import com.example.vibe.ui.views.ToolCallWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChatMessageComposite
extends Composite {
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.+?)\\*\\*|__(.+?)__");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("(?<![\\*_])\\*([^\\*]+)\\*(?![\\*_])|(?<![\\*_])_([^_]+)_(?![\\*_])");
    private static final Pattern INLINE_CODE_PATTERN = Pattern.compile("`([^`]+)`");
    private static final Pattern HEADER_PATTERN = Pattern.compile("^(#{1,6})\\s+(.+)$", 8);
    private static final Pattern TABLE_PATTERN = Pattern.compile("(^\\|.+\\|\\s*\\n)(^\\|[-:|\\s]+\\|\\s*\\n)((?:^\\|.+\\|\\s*\\n?)+)", 8);
    private final String sender;
    private final String message;
    private final boolean isAssistant;
    private final MessageKind messageKind;
    private final List<CodeBlockWidget> codeBlockWidgets = new ArrayList<CodeBlockWidget>();
    private final List<ToolCallWidget> toolCallWidgets = new ArrayList<ToolCallWidget>();
    private final Map<String, ToolCallWidget> toolCallWidgetMap = new HashMap<String, ToolCallWidget>();
    private final List<TodoListWidget> todoListWidgets = new ArrayList<TodoListWidget>();
    private final MessageContentParser contentParser = new MessageContentParser();
    private final VibeTheme theme;

    public ChatMessageComposite(Composite parent, String sender, String message, boolean isAssistant) {
        super(parent, 0);
        this.sender = sender;
        this.message = message != null ? message : "";
        this.isAssistant = isAssistant;
        this.messageKind = isAssistant ? MessageKind.ASSISTANT : MessageKind.USER;
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContents();
    }

    public ChatMessageComposite(Composite parent, ChatMessage chatMessage) {
        super(parent, 0);
        this.sender = chatMessage.getKind().getDisplayName();
        this.message = chatMessage.getRawContent() != null ? chatMessage.getRawContent() : "";
        this.isAssistant = chatMessage.getKind().isAssistantOutput();
        this.messageKind = chatMessage.getKind();
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContentsFromChatMessage(chatMessage);
    }

    private void createContents() {
        this.setBackground(this.getMessageBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.theme.getMargin();
        layout.marginHeight = this.theme.getMargin();
        layout.verticalSpacing = this.theme.getMarginSmall();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.createSenderLabel();
        this.parseAndRenderMessage();
    }

    private Color getMessageBackground() {
        if (this.isAssistant) {
            return this.theme.getAssistantMessageBackground();
        }
        if ("\u0421\u0438\u0441\u0442\u0435\u043c\u0430".equals(this.sender) || "System".equals(this.sender)) {
            return this.theme.getSystemMessageBackground();
        }
        return this.theme.getUserMessageBackground();
    }

    private void createContentsFromChatMessage(ChatMessage chatMessage) {
        this.setBackground(this.getMessageBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.theme.getMargin();
        layout.marginHeight = this.theme.getMargin();
        layout.verticalSpacing = this.theme.getMarginSmall();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.createSenderLabel();
        List<MessagePart> parts = chatMessage.getParts();
        if (!parts.isEmpty()) {
            for (MessagePart part : parts) {
                this.renderPart(part);
            }
        } else {
            this.parseAndRenderMessage();
        }
    }

    private void createSenderLabel() {
        Label senderLabel = new Label((Composite)this, 0);
        senderLabel.setBackground(this.getBackground());
        senderLabel.setText(this.sender);
        senderLabel.setFont(this.theme.getFontBold());
        senderLabel.setForeground(this.isAssistant ? this.theme.getAccent() : this.theme.getText());
        senderLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void parseAndRenderMessage() {
        List<MessagePart> parts = this.contentParser.parse(this.message);
        if (parts.isEmpty() && !this.message.trim().isEmpty()) {
            this.createStyledTextWidget(this.message);
        } else {
            for (MessagePart part : parts) {
                this.renderPart(part);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void renderPart(MessagePart part) {
        MessagePart messagePart = part;
        if (messagePart instanceof MessagePart.TextPart) {
            void textPart;
            MessagePart.TextPart textPart2 = (MessagePart.TextPart)messagePart;
            MessagePart.TextPart cfr_ignored_0 = (MessagePart.TextPart)messagePart;
            this.createStyledTextWidget(textPart.content());
        } else {
            MessagePart messagePart2 = part;
            if (messagePart2 instanceof MessagePart.CodeBlockPart) {
                void codeBlock;
                MessagePart.CodeBlockPart codeBlockPart = (MessagePart.CodeBlockPart)messagePart2;
                MessagePart.CodeBlockPart cfr_ignored_1 = (MessagePart.CodeBlockPart)messagePart2;
                this.createCodeBlockWidget((MessagePart.CodeBlockPart)codeBlock);
            } else {
                MessagePart messagePart3 = part;
                if (messagePart3 instanceof MessagePart.ToolCallPart) {
                    void toolCall;
                    MessagePart.ToolCallPart toolCallPart = (MessagePart.ToolCallPart)messagePart3;
                    MessagePart.ToolCallPart cfr_ignored_2 = (MessagePart.ToolCallPart)messagePart3;
                    this.createToolCallWidget((MessagePart.ToolCallPart)toolCall);
                } else {
                    MessagePart messagePart4 = part;
                    if (messagePart4 instanceof MessagePart.ToolResultPart) {
                        void toolResult;
                        MessagePart.ToolResultPart toolResultPart = (MessagePart.ToolResultPart)messagePart4;
                        MessagePart.ToolResultPart cfr_ignored_3 = (MessagePart.ToolResultPart)messagePart4;
                        this.updateToolCallWithResult((MessagePart.ToolResultPart)toolResult);
                    } else {
                        MessagePart messagePart5 = part;
                        if (messagePart5 instanceof MessagePart.TodoListPart) {
                            void todoList;
                            MessagePart.TodoListPart todoListPart = (MessagePart.TodoListPart)messagePart5;
                            MessagePart.TodoListPart cfr_ignored_4 = (MessagePart.TodoListPart)messagePart5;
                            this.createTodoListWidget((MessagePart.TodoListPart)todoList);
                        }
                    }
                }
            }
        }
    }

    private void createCodeBlockWidget(MessagePart.CodeBlockPart codeBlock) {
        CodeBlockWidget codeWidget = new CodeBlockWidget(this, codeBlock.code(), codeBlock.language());
        codeWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.codeBlockWidgets.add(codeWidget);
    }

    private void createToolCallWidget(MessagePart.ToolCallPart toolCall) {
        ToolCallWidget toolWidget = new ToolCallWidget(this, toolCall);
        toolWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.toolCallWidgets.add(toolWidget);
        this.toolCallWidgetMap.put(toolCall.toolCallId(), toolWidget);
    }

    private void updateToolCallWithResult(MessagePart.ToolResultPart result) {
        ToolCallWidget widget = this.toolCallWidgetMap.get(result.toolCallId());
        if (widget != null && !widget.isDisposed()) {
            widget.setResult(result);
        } else {
            this.createToolResultWidget(result);
        }
    }

    private void createToolResultWidget(MessagePart.ToolResultPart result) {
        Composite resultComposite = new Composite((Composite)this, 0);
        resultComposite.setBackground(this.theme.getToolResultBackground());
        resultComposite.setLayout((Layout)new GridLayout(1, false));
        resultComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(resultComposite, 0);
        label.setBackground(resultComposite.getBackground());
        label.setForeground(result.success() ? this.theme.getSuccess() : this.theme.getDanger());
        label.setFont(this.theme.getFontBold());
        label.setText(result.success() ? "\u2713 " + result.toolName() : "\u2717 " + result.toolName());
        if (result.content() != null && !result.content().isEmpty()) {
            StyledText text = new StyledText(resultComposite, 74);
            text.setBackground(resultComposite.getBackground());
            text.setForeground(this.theme.getText());
            text.setFont(this.theme.getFontMono());
            Object displayContent = result.content();
            if (((String)displayContent).length() > 500) {
                displayContent = ((String)displayContent).substring(0, 500) + "...";
            }
            text.setText((String)displayContent);
            text.setEditable(false);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
    }

    private void createTodoListWidget(MessagePart.TodoListPart todoList) {
        TodoListWidget todoWidget = new TodoListWidget((Composite)this, todoList);
        todoWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.todoListWidgets.add(todoWidget);
    }

    private void createStyledTextWidget(String text) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        String processedText = this.processMarkdownFormatting(text, styles);
        StyledText styledText = new StyledText((Composite)this, 72);
        styledText.setText(processedText);
        styledText.setEditable(false);
        styledText.setBackground(this.getBackground());
        styledText.setForeground(this.theme.getText());
        styledText.setFont(this.theme.getFont());
        styledText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (StyleRange style : styles) {
            if (style.start < 0 || style.start + style.length > styledText.getCharCount()) continue;
            styledText.setStyleRange(style);
        }
    }

    private String processMarkdownFormatting(String text, List<StyleRange> styles) {
        text = this.processTables(text, styles);
        text = this.processHeaders(text, styles);
        text = this.processBold(text, styles);
        text = this.processItalic(text, styles);
        text = this.processInlineCode(text, styles);
        return text;
    }

    private String processHeaders(String text, List<StyleRange> styles) {
        Matcher matcher = HEADER_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String headerText = matcher.group(2);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(headerText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = headerText.length();
            style.font = this.theme.getFontHeader();
            style.foreground = this.theme.getAccent();
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processBold(String text, List<StyleRange> styles) {
        Matcher matcher = BOLD_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String boldText = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(boldText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = boldText.length();
            style.font = this.theme.getFontBold();
            style.fontStyle = 1;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processItalic(String text, List<StyleRange> styles) {
        Matcher matcher = ITALIC_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String italicText = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(italicText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = italicText.length();
            style.font = this.theme.getFontItalic();
            style.fontStyle = 2;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processInlineCode(String text, List<StyleRange> styles) {
        Matcher matcher = INLINE_CODE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String codeText = matcher.group(1);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(codeText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = codeText.length();
            style.font = this.theme.getFontMono();
            style.foreground = this.theme.getCodeText();
            style.background = this.theme.getInlineCodeBackground();
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processTables(String text, List<StyleRange> styles) {
        Matcher matcher = TABLE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            Object cells;
            String headerRow = matcher.group(1).trim();
            String dataRows = matcher.group(3);
            String[] headers = this.parseTableRow(headerRow);
            if (headers.length == 0) continue;
            String[] dataLines = dataRows.split("\\n");
            ArrayList<String[]> rows = new ArrayList<String[]>();
            String[] stringArray = dataLines;
            int n = dataLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim()).isEmpty() && line.startsWith("|") && ((String[])(cells = this.parseTableRow(line))).length > 0) {
                    rows.add((String[])cells);
                }
                ++n2;
            }
            int[] widths = new int[headers.length];
            int i = 0;
            while (i < headers.length) {
                widths[i] = headers[i].length();
                ++i;
            }
            for (String[] row : rows) {
                int i2 = 0;
                while (i2 < Math.min(row.length, widths.length)) {
                    widths[i2] = Math.max(widths[i2], row[i2].length());
                    ++i2;
                }
            }
            StringBuilder table = new StringBuilder();
            int startPos = sb.length();
            table.append(this.buildTableBorder(widths, '\u250c', '\u252c', '\u2510')).append("\n");
            table.append(this.buildTableRow(headers, widths)).append("\n");
            table.append(this.buildTableBorder(widths, '\u251c', '\u253c', '\u2524')).append("\n");
            cells = rows.iterator();
            while (cells.hasNext()) {
                String[] row = (String[])cells.next();
                table.append(this.buildTableRow(row, widths)).append("\n");
            }
            table.append(this.buildTableBorder(widths, '\u2514', '\u2534', '\u2518'));
            String tableText = table.toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(tableText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = tableText.length();
            style.font = this.theme.getFontMono();
            style.foreground = this.theme.getAccent();
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String[] parseTableRow(String row) {
        if ((row = row.trim()).startsWith("|")) {
            row = row.substring(1);
        }
        if (row.endsWith("|")) {
            row = row.substring(0, row.length() - 1);
        }
        String[] cells = row.split("\\|");
        int i = 0;
        while (i < cells.length) {
            cells[i] = cells[i].trim();
            ++i;
        }
        return cells;
    }

    private String buildTableBorder(int[] widths, char left, char middle, char right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        int i = 0;
        while (i < widths.length) {
            int j = 0;
            while (j < widths[i] + 2) {
                sb.append('\u2500');
                ++j;
            }
            if (i < widths.length - 1) {
                sb.append(middle);
            }
            ++i;
        }
        sb.append(right);
        return sb.toString();
    }

    private String buildTableRow(String[] cells, int[] widths) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u2502');
        int i = 0;
        while (i < widths.length) {
            sb.append(' ');
            String cell = i < cells.length ? cells[i] : "";
            sb.append(cell);
            int j = cell.length();
            while (j < widths[i]) {
                sb.append(' ');
                ++j;
            }
            sb.append(' ');
            sb.append('\u2502');
            ++i;
        }
        return sb.toString();
    }

    public void updateToolCallStatus(String toolCallId, MessagePart.ToolCallPart.ToolCallStatus status) {
        ToolCallWidget widget = this.toolCallWidgetMap.get(toolCallId);
        if (widget != null && !widget.isDisposed()) {
            widget.setStatus(status);
        }
    }

    public void addToolResult(MessagePart.ToolResultPart result) {
        this.updateToolCallWithResult(result);
    }

    public List<CodeBlockWidget> getCodeBlockWidgets() {
        return new ArrayList<CodeBlockWidget>(this.codeBlockWidgets);
    }

    public List<ToolCallWidget> getToolCallWidgets() {
        return new ArrayList<ToolCallWidget>(this.toolCallWidgets);
    }

    public MessageKind getMessageKind() {
        return this.messageKind;
    }

    public void dispose() {
        for (CodeBlockWidget codeBlockWidget : this.codeBlockWidgets) {
            if (codeBlockWidget.isDisposed()) continue;
            codeBlockWidget.dispose();
        }
        this.codeBlockWidgets.clear();
        for (ToolCallWidget toolCallWidget : this.toolCallWidgets) {
            if (toolCallWidget.isDisposed()) continue;
            toolCallWidget.dispose();
        }
        this.toolCallWidgets.clear();
        this.toolCallWidgetMap.clear();
        for (TodoListWidget todoListWidget : this.todoListWidgets) {
            if (todoListWidget.isDisposed()) continue;
            todoListWidget.dispose();
        }
        this.todoListWidgets.clear();
        super.dispose();
    }
}

