/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.editor.CodeApplicationService;
import com.example.vibe.ui.internal.Messages;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CodeBlockWidget
extends Composite {
    private static final int MAX_VISIBLE_LINES = 15;
    private static final int MIN_VISIBLE_LINES = 3;
    private final String code;
    private final String language;
    private final VibeTheme theme;
    private StyledText codeText;
    private Composite headerComposite;
    private Label expandLabel;
    private boolean expanded = false;
    private int totalLines;

    public CodeBlockWidget(Composite parent, String code, String language) {
        super(parent, 0);
        this.code = code != null ? code : "";
        this.language = language;
        this.theme = ThemeManager.getInstance().getTheme();
        this.totalLines = this.code.split("\n", -1).length;
        this.createContents();
    }

    private void createContents() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 128, true, false));
        this.addListener(9, this::paintBorder);
        this.createHeader();
        this.createCodeArea();
    }

    private void createHeader() {
        this.headerComposite = new Composite((Composite)this, 0);
        this.headerComposite.setBackground(this.theme.getCodeBackground());
        GridLayout headerLayout = new GridLayout(6, false);
        headerLayout.marginWidth = this.theme.getPadding();
        headerLayout.marginHeight = this.theme.getMarginSmall();
        headerLayout.horizontalSpacing = this.theme.getMargin();
        this.headerComposite.setLayout((Layout)headerLayout);
        this.headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label langLabel = new Label(this.headerComposite, 0);
        langLabel.setBackground(this.headerComposite.getBackground());
        langLabel.setForeground(this.theme.getTextMuted());
        langLabel.setFont(this.theme.getFontSmall());
        if (this.language != null && !this.language.isEmpty()) {
            langLabel.setText(this.language.toUpperCase());
        } else {
            langLabel.setText("CODE");
        }
        langLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label linesLabel = new Label(this.headerComposite, 0);
        linesLabel.setBackground(this.headerComposite.getBackground());
        linesLabel.setForeground(this.theme.getTextMuted());
        linesLabel.setFont(this.theme.getFontSmall());
        linesLabel.setText(this.totalLines + " " + (this.totalLines == 1 ? "\u0441\u0442\u0440\u043e\u043a\u0430" : "\u0441\u0442\u0440\u043e\u043a"));
        this.createActionButton(this.headerComposite, "\u2398", Messages.CodeBlockWidget_Copy, this::copyToClipboard);
        this.createActionButton(this.headerComposite, "\u2913", Messages.CodeBlockWidget_Insert, this::insertCode);
        this.createActionButton(this.headerComposite, "\u21c4", Messages.CodeBlockWidget_Replace, this::replaceCode);
        if (this.totalLines > 15) {
            this.expandLabel = this.createActionButton(this.headerComposite, "\u25bc", "\u0420\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c", this::toggleExpand);
        }
    }

    private Label createActionButton(Composite parent, String icon, String tooltip, final Runnable action) {
        final Label btn = new Label(parent, 0);
        btn.setText(icon);
        btn.setToolTipText(tooltip);
        btn.setFont(this.theme.getFont());
        btn.setForeground(this.theme.getTextMuted());
        btn.setBackground(parent.getBackground());
        btn.setCursor(this.getDisplay().getSystemCursor(21));
        btn.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                btn.setForeground(CodeBlockWidget.this.theme.getAccent());
            }

            public void mouseExit(MouseEvent e) {
                btn.setForeground(CodeBlockWidget.this.theme.getTextMuted());
            }
        });
        btn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                action.run();
            }
        });
        return btn;
    }

    private void createCodeArea() {
        this.codeText = new StyledText((Composite)this, 778);
        this.codeText.setText(this.code);
        this.codeText.setEditable(false);
        this.codeText.setBackground(this.theme.getCodeBackground());
        this.codeText.setForeground(this.theme.getCodeText());
        this.codeText.setFont(this.theme.getFontMono());
        int visibleLines = Math.min(this.totalLines, this.expanded ? this.totalLines : 15);
        visibleLines = Math.max(visibleLines, 3);
        GridData codeData = new GridData(4, 128, true, false);
        codeData.heightHint = visibleLines * this.codeText.getLineHeight() + this.theme.getPadding() * 2;
        this.codeText.setLayoutData((Object)codeData);
        this.codeText.setMargins(this.theme.getPadding(), this.theme.getMargin(), this.theme.getPadding(), this.theme.getMargin());
        if (this.language != null) {
            this.applySyntaxHighlighting();
        }
    }

    private void applySyntaxHighlighting() {
        String lang = this.language.toLowerCase();
        if (lang.equals("bsl") || lang.equals("1c")) {
            this.highlightBsl();
        } else if (lang.equals("java")) {
            this.highlightJava();
        } else if (lang.equals("javascript") || lang.equals("js") || lang.equals("typescript") || lang.equals("ts")) {
            this.highlightJavaScript();
        } else if (lang.equals("python") || lang.equals("py")) {
            this.highlightPython();
        }
    }

    private void highlightBsl() {
        String[] keywords = new String[]{"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430", "\u041a\u043e\u043d\u0435\u0446\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b", "\u0424\u0443\u043d\u043a\u0446\u0438\u044f", "\u041a\u043e\u043d\u0435\u0446\u0424\u0443\u043d\u043a\u0446\u0438\u0438", "\u0415\u0441\u043b\u0438", "\u0422\u043e\u0433\u0434\u0430", "\u0418\u043d\u0430\u0447\u0435", "\u0418\u043d\u0430\u0447\u0435\u0415\u0441\u043b\u0438", "\u041a\u043e\u043d\u0435\u0446\u0415\u0441\u043b\u0438", "\u0414\u043b\u044f", "\u041a\u0430\u0436\u0434\u043e\u0433\u043e", "\u0418\u0437", "\u041f\u043e", "\u0426\u0438\u043a\u043b", "\u041a\u043e\u043d\u0435\u0446\u0426\u0438\u043a\u043b\u0430", "\u041f\u043e\u043a\u0430", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430", "\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", "\u041a\u043e\u043d\u0435\u0446\u041f\u043e\u043f\u044b\u0442\u043a\u0438", "\u0412\u044b\u0437\u0432\u0430\u0442\u044c\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", "\u0412\u043e\u0437\u0432\u0440\u0430\u0442", "\u041f\u0435\u0440\u0435\u043c", "\u041d\u043e\u0432\u044b\u0439", "\u0418", "\u0418\u043b\u0438", "\u041d\u0435", "\u0418\u0441\u0442\u0438\u043d\u0430", "\u041b\u043e\u0436\u044c", "\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e", "NULL", "Procedure", "EndProcedure", "Function", "EndFunction", "If", "Then", "Else", "ElsIf", "EndIf", "For", "Each", "In", "To", "Do", "EndDo", "While", "Try", "Except", "EndTry", "Raise", "Return", "Var", "New", "And", "Or", "Not", "True", "False", "Undefined"};
        this.highlightKeywords(keywords, this.theme.getAccent());
    }

    private void highlightJava() {
        String[] keywords = new String[]{"public", "private", "protected", "class", "interface", "enum", "extends", "implements", "static", "final", "abstract", "void", "int", "long", "double", "float", "boolean", "char", "byte", "short", "if", "else", "for", "while", "do", "switch", "case", "default", "break", "continue", "try", "catch", "finally", "throw", "throws", "return", "new", "this", "super", "null", "true", "false", "import", "package", "instanceof"};
        this.highlightKeywords(keywords, this.theme.getAccent());
    }

    private void highlightJavaScript() {
        String[] keywords = new String[]{"const", "let", "var", "function", "class", "extends", "if", "else", "for", "while", "do", "switch", "case", "default", "break", "continue", "try", "catch", "finally", "throw", "return", "new", "this", "super", "null", "undefined", "true", "false", "import", "export", "from", "default", "async", "await", "typeof", "instanceof", "in", "of"};
        this.highlightKeywords(keywords, this.theme.getAccent());
    }

    private void highlightPython() {
        String[] keywords = new String[]{"def", "class", "if", "elif", "else", "for", "while", "try", "except", "finally", "raise", "with", "as", "return", "yield", "import", "from", "global", "nonlocal", "True", "False", "None", "and", "or", "not", "in", "is", "lambda", "pass", "break", "continue", "assert"};
        this.highlightKeywords(keywords, this.theme.getAccent());
    }

    private void highlightKeywords(String[] keywords, Color color) {
        String text = this.codeText.getText();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            int index = 0;
            while ((index = text.indexOf(keyword, index)) >= 0) {
                boolean validEnd;
                boolean validStart = index == 0 || !Character.isLetterOrDigit(text.charAt(index - 1));
                boolean bl = validEnd = index + keyword.length() >= text.length() || !Character.isLetterOrDigit(text.charAt(index + keyword.length()));
                if (validStart && validEnd) {
                    StyleRange style = new StyleRange();
                    style.start = index;
                    style.length = keyword.length();
                    style.foreground = color;
                    style.fontStyle = 1;
                    this.codeText.setStyleRange(style);
                }
                index += keyword.length();
            }
            ++n2;
        }
    }

    private void paintBorder(Event e) {
        GC gc = e.gc;
        Rectangle bounds = this.getClientArea();
        gc.setForeground(this.theme.getBorder());
        gc.setLineWidth(1);
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
    }

    private void toggleExpand() {
        boolean bl = this.expanded = !this.expanded;
        if (this.expandLabel != null && !this.expandLabel.isDisposed()) {
            this.expandLabel.setText(this.expanded ? "\u25b2" : "\u25bc");
            this.expandLabel.setToolTipText(this.expanded ? "\u0421\u0432\u0435\u0440\u043d\u0443\u0442\u044c" : "\u0420\u0430\u0437\u0432\u0435\u0440\u043d\u0443\u0442\u044c");
        }
        int visibleLines = this.expanded ? this.totalLines : 15;
        visibleLines = Math.max(visibleLines, 3);
        GridData codeData = (GridData)this.codeText.getLayoutData();
        codeData.heightHint = visibleLines * this.codeText.getLineHeight() + this.theme.getPadding() * 2;
        Composite parent = this.getParent();
        while (parent != null && !(parent instanceof ScrolledComposite)) {
            parent.layout(true, true);
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledComposite) {
            ((ScrolledComposite)parent).setMinSize(((ScrolledComposite)parent).getContent().computeSize(-1, -1));
        }
    }

    private void copyToClipboard() {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{this.code}, new Transfer[]{textTransfer});
        }
        finally {
            clipboard.dispose();
        }
    }

    private void insertCode() {
        CodeApplicationService service = CodeApplicationService.getInstance();
        service.insertAtCursor(this.code);
    }

    private void replaceCode() {
        CodeApplicationService service = CodeApplicationService.getInstance();
        service.replaceSelection(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getLanguage() {
        return this.language;
    }

    public void dispose() {
        super.dispose();
    }
}

