/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.core.review.BslReviewIssue;
import com.example.vibe.core.review.IssueSeverity;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ReviewIssueWidget
extends Composite {
    private final VibeTheme theme = ThemeManager.getInstance().getTheme();
    private final BslReviewIssue issue;
    private Color criticalColor;
    private Color warningColor;
    private Color infoColor;
    private Color hintColor;
    private Font badgeFont;

    public ReviewIssueWidget(Composite parent, BslReviewIssue issue) {
        super(parent, 0);
        this.issue = issue;
        this.initializeColors();
        this.createContents();
    }

    private void initializeColors() {
        FontData[] fontData;
        Display display = this.getDisplay();
        this.criticalColor = new Color((Device)display, 220, 53, 69);
        this.warningColor = new Color((Device)display, 255, 152, 0);
        this.infoColor = new Color((Device)display, 33, 150, 243);
        this.hintColor = new Color((Device)display, 158, 158, 158);
        FontData[] fontDataArray = fontData = this.theme.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(fd.getHeight() - 1);
            fd.setStyle(1);
            ++n2;
        }
        this.badgeFont = new Font((Device)display, fontData);
    }

    private void createContents() {
        this.setBackground(this.theme.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 8;
        layout.marginHeight = 6;
        layout.verticalSpacing = 4;
        this.setLayout((Layout)layout);
        Composite headerRow = new Composite((Composite)this, 0);
        headerRow.setBackground(this.getBackground());
        headerRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 0;
        headerLayout.marginHeight = 0;
        headerLayout.horizontalSpacing = 8;
        headerRow.setLayout((Layout)headerLayout);
        this.createSeverityBadge(headerRow);
        this.createConfidenceBadge(headerRow);
        Label descLabel = new Label(headerRow, 64);
        descLabel.setText(this.issue.getDescription());
        descLabel.setFont(this.theme.getFont());
        descLabel.setForeground(this.theme.getText());
        descLabel.setBackground(headerRow.getBackground());
        descLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.issue.getFilePath() != null && this.issue.getLineNumber() > 0) {
            Label locationLabel = new Label((Composite)this, 0);
            locationLabel.setText("\ud83d\udccd " + this.issue.getLocation());
            locationLabel.setFont(this.theme.getFontMono());
            locationLabel.setForeground(this.theme.getTextMuted());
            locationLabel.setBackground(this.getBackground());
            GridData locData = new GridData(4, 0x1000000, true, false);
            locData.horizontalIndent = 60;
            locationLabel.setLayoutData((Object)locData);
        }
        if (this.issue.getCodeSnippet() != null && !this.issue.getCodeSnippet().isEmpty()) {
            Composite snippetBox = new Composite((Composite)this, 0);
            snippetBox.setBackground(this.theme.getCodeBackground());
            GridData snippetData = new GridData(4, 0x1000000, true, false);
            snippetData.horizontalIndent = 60;
            snippetBox.setLayoutData((Object)snippetData);
            GridLayout snippetLayout = new GridLayout(1, false);
            snippetLayout.marginWidth = 8;
            snippetLayout.marginHeight = 4;
            snippetBox.setLayout((Layout)snippetLayout);
            Label snippetLabel = new Label(snippetBox, 64);
            snippetLabel.setText(this.issue.getCodeSnippet());
            snippetLabel.setFont(this.theme.getFontMono());
            snippetLabel.setForeground(this.theme.getCodeText());
            snippetLabel.setBackground(snippetBox.getBackground());
            snippetLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        if (this.issue.getSuggestedFix() != null && !this.issue.getSuggestedFix().isEmpty()) {
            Label fixLabel = new Label((Composite)this, 64);
            fixLabel.setText("\ud83d\udca1 " + this.issue.getSuggestedFix());
            fixLabel.setFont(this.theme.getFont());
            fixLabel.setForeground(this.theme.getAccent());
            fixLabel.setBackground(this.getBackground());
            GridData fixData = new GridData(4, 0x1000000, true, false);
            fixData.horizontalIndent = 60;
            fixLabel.setLayoutData((Object)fixData);
        }
    }

    private void createSeverityBadge(Composite parent) {
        IssueSeverity severity = this.issue.getSeverity();
        Color badgeColor = this.getSeverityColor(severity);
        String icon = this.getSeverityIcon(severity);
        Label badge = new Label(parent, 0x1000000);
        badge.setText(icon);
        badge.setFont(this.badgeFont);
        badge.setForeground(badgeColor);
        badge.setBackground(parent.getBackground());
        GridData badgeData = new GridData(16384, 0x1000000, false, false);
        badgeData.widthHint = 20;
        badge.setLayoutData((Object)badgeData);
        badge.setToolTipText(severity.getDisplayName());
    }

    private void createConfidenceBadge(Composite parent) {
        int confidence = this.issue.getConfidence();
        Color badgeColor = this.getConfidenceColor(confidence);
        Composite badgeContainer = new Composite(parent, 0);
        badgeContainer.setBackground(badgeColor);
        GridLayout badgeLayout = new GridLayout(1, false);
        badgeLayout.marginWidth = 6;
        badgeLayout.marginHeight = 2;
        badgeContainer.setLayout((Layout)badgeLayout);
        Label badge = new Label(badgeContainer, 0x1000000);
        badge.setText(confidence + "%");
        badge.setFont(this.badgeFont);
        badge.setForeground(this.getDisplay().getSystemColor(1));
        badge.setBackground(badgeContainer.getBackground());
        GridData containerData = new GridData(16384, 0x1000000, false, false);
        badgeContainer.setLayoutData((Object)containerData);
        badgeContainer.setToolTipText("\u0423\u0432\u0435\u0440\u0435\u043d\u043d\u043e\u0441\u0442\u044c: " + confidence + "%");
    }

    private Color getSeverityColor(IssueSeverity severity) {
        return switch (severity) {
            case IssueSeverity.CRITICAL -> this.criticalColor;
            case IssueSeverity.WARNING -> this.warningColor;
            case IssueSeverity.INFO -> this.infoColor;
            case IssueSeverity.HINT -> this.hintColor;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private String getSeverityIcon(IssueSeverity severity) {
        return switch (severity) {
            case IssueSeverity.CRITICAL -> "\ud83d\udd34";
            case IssueSeverity.WARNING -> "\ud83d\udfe0";
            case IssueSeverity.INFO -> "\ud83d\udd35";
            case IssueSeverity.HINT -> "\u26aa";
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private Color getConfidenceColor(int confidence) {
        if (confidence >= 90) {
            return this.criticalColor;
        }
        if (confidence >= 80) {
            return this.warningColor;
        }
        if (confidence >= 60) {
            return this.infoColor;
        }
        return this.hintColor;
    }

    public BslReviewIssue getIssue() {
        return this.issue;
    }

    public void dispose() {
        if (this.criticalColor != null && !this.criticalColor.isDisposed()) {
            this.criticalColor.dispose();
        }
        if (this.warningColor != null && !this.warningColor.isDisposed()) {
            this.warningColor.dispose();
        }
        if (this.infoColor != null && !this.infoColor.isDisposed()) {
            this.infoColor.dispose();
        }
        if (this.hintColor != null && !this.hintColor.isDisposed()) {
            this.hintColor.dispose();
        }
        if (this.badgeFont != null && !this.badgeFont.isDisposed()) {
            this.badgeFont.dispose();
        }
        super.dispose();
    }
}

