/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.chat.MessagePart;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ToolCallWidget
extends Composite {
    private final String toolName;
    private final String toolCallId;
    private MessagePart.ToolCallPart.ToolCallStatus status;
    private String resultContent;
    private boolean resultSuccess;
    private Label statusLabel;
    private Composite contentArea;
    private StyledText resultText;
    private boolean expanded = false;
    private final VibeTheme theme;

    public ToolCallWidget(Composite parent, MessagePart.ToolCallPart toolCall) {
        super(parent, 0);
        this.toolName = toolCall.toolName();
        this.toolCallId = toolCall.toolCallId();
        this.status = toolCall.status();
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContents();
    }

    public ToolCallWidget(Composite parent, String toolName, String toolCallId, MessagePart.ToolCallPart.ToolCallStatus status) {
        super(parent, 0);
        this.toolName = toolName;
        this.toolCallId = toolCallId;
        this.status = status;
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContents();
    }

    private void createContents() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.createHeader();
        this.createContentArea();
    }

    private void createHeader() {
        Composite header = new Composite((Composite)this, 0);
        header.setBackground(this.theme.getToolCallBackground());
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = this.theme.getMargin();
        headerLayout.marginHeight = this.theme.getMarginSmall();
        header.setLayout((Layout)headerLayout);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button toggleButton = new Button(header, 0x800008);
        toggleButton.setText(this.expanded ? "\u25bc" : "\u25b6");
        toggleButton.setFont(this.theme.getFont());
        toggleButton.addListener(13, e -> {
            this.expanded = !this.expanded;
            toggleButton.setText(this.expanded ? "\u25bc" : "\u25b6");
            this.updateContentVisibility();
        });
        Label nameLabel = new Label(header, 0);
        nameLabel.setBackground(header.getBackground());
        nameLabel.setForeground(this.theme.getText());
        nameLabel.setFont(this.theme.getFontBold());
        nameLabel.setText("\ud83d\udd27 " + this.getToolDisplayName(this.toolName));
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.statusLabel = new Label(header, 0);
        this.statusLabel.setBackground(header.getBackground());
        this.statusLabel.setFont(this.theme.getFontSmall());
        this.updateStatusLabel();
    }

    private void createContentArea() {
        this.contentArea = new Composite((Composite)this, 0);
        this.contentArea.setBackground(this.theme.getToolResultBackground());
        GridLayout contentLayout = new GridLayout(1, false);
        contentLayout.marginWidth = this.theme.getMarginLarge();
        contentLayout.marginHeight = this.theme.getMargin();
        this.contentArea.setLayout((Layout)contentLayout);
        GridData contentData = new GridData(4, 0x1000000, true, false);
        contentData.exclude = !this.expanded;
        this.contentArea.setLayoutData((Object)contentData);
        this.contentArea.setVisible(this.expanded);
        this.resultText = new StyledText(this.contentArea, 74);
        this.resultText.setBackground(this.contentArea.getBackground());
        this.resultText.setForeground(this.theme.getText());
        this.resultText.setEditable(false);
        this.resultText.setText("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430...");
        this.resultText.setFont(this.theme.getFontMono());
        GridData textData = new GridData(4, 0x1000000, true, false);
        textData.widthHint = 400;
        this.resultText.setLayoutData((Object)textData);
        this.resultText.setMargins(this.theme.getMarginSmall(), this.theme.getMarginSmall(), this.theme.getMarginSmall(), this.theme.getMarginSmall());
    }

    private void updateContentVisibility() {
        GridData contentData = (GridData)this.contentArea.getLayoutData();
        contentData.exclude = !this.expanded;
        this.contentArea.setVisible(this.expanded);
        this.relayoutParentChain();
    }

    private void relayoutParentChain() {
        Composite parent = this.getParent();
        while (parent != null && !parent.isDisposed()) {
            parent.layout(true, true);
            if (parent instanceof ScrolledComposite) {
                int width;
                ScrolledComposite sc = (ScrolledComposite)parent;
                Control content = sc.getContent();
                if (content == null || content.isDisposed() || (width = sc.getClientArea().width) <= 0) break;
                Point size = content.computeSize(width, -1);
                content.setSize(size);
                sc.setMinSize(size);
                break;
            }
            parent = parent.getParent();
        }
    }

    private void updateStatusLabel() {
        String statusText;
        Color color = switch (this.status) {
            case MessagePart.ToolCallPart.ToolCallStatus.PENDING -> {
                statusText = "\u23f3 \u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435";
                yield this.theme.getTextMuted();
            }
            case MessagePart.ToolCallPart.ToolCallStatus.RUNNING -> {
                statusText = "\u25b6 \u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f";
                yield this.theme.getAccent();
            }
            case MessagePart.ToolCallPart.ToolCallStatus.SUCCESS -> {
                statusText = "\u2713 \u0413\u043e\u0442\u043e\u0432\u043e";
                yield this.theme.getSuccess();
            }
            case MessagePart.ToolCallPart.ToolCallStatus.FAILED -> {
                statusText = "\u2717 \u041e\u0448\u0438\u0431\u043a\u0430";
                yield this.theme.getDanger();
            }
            case MessagePart.ToolCallPart.ToolCallStatus.CANCELLED -> {
                statusText = "\u2716 \u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e";
                yield this.theme.getTextMuted();
            }
            case MessagePart.ToolCallPart.ToolCallStatus.NEEDS_CONFIRMATION -> {
                statusText = "\u26a0 \u0422\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f";
                yield this.theme.getWarning();
            }
            default -> {
                statusText = "";
                yield this.theme.getTextMuted();
            }
        };
        this.statusLabel.setText(statusText);
        this.statusLabel.setForeground(color);
    }

    private String getToolDisplayName(String name) {
        return switch (name) {
            case "read_file" -> "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "edit_file" -> "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "list_files" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
            case "grep" -> "\u041f\u043e\u0438\u0441\u043a \u0442\u0435\u043a\u0441\u0442\u0430";
            case "search_codebase" -> "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043a\u043e\u0434\u0443";
            default -> name;
        };
    }

    public void setStatus(MessagePart.ToolCallPart.ToolCallStatus newStatus) {
        this.status = newStatus;
        if (!this.statusLabel.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.statusLabel.isDisposed()) {
                    this.updateStatusLabel();
                }
            });
        }
    }

    public void setResult(MessagePart.ToolResultPart result) {
        this.resultContent = result.content();
        this.resultSuccess = result.success();
        MessagePart.ToolCallPart.ToolCallStatus toolCallStatus = this.status = this.resultSuccess ? MessagePart.ToolCallPart.ToolCallStatus.SUCCESS : MessagePart.ToolCallPart.ToolCallStatus.FAILED;
        if (!this.resultText.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.resultText.isDisposed()) {
                    Object displayContent = this.resultContent;
                    if (displayContent != null && ((String)displayContent).length() > 2000) {
                        displayContent = ((String)displayContent).substring(0, 2000) + "\n... (\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e)";
                    }
                    this.resultText.setText((String)(displayContent != null ? displayContent : ""));
                    this.updateStatusLabel();
                    if (this.resultContent == null || !this.resultContent.isEmpty()) {
                        // empty if block
                    }
                }
            });
        }
    }

    public void setResult(String content, boolean success) {
        this.resultContent = content;
        this.resultSuccess = success;
        MessagePart.ToolCallPart.ToolCallStatus toolCallStatus = this.status = success ? MessagePart.ToolCallPart.ToolCallStatus.SUCCESS : MessagePart.ToolCallPart.ToolCallStatus.FAILED;
        if (!this.resultText.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.resultText.isDisposed()) {
                    Object displayContent = content;
                    if (displayContent != null && ((String)displayContent).length() > 2000) {
                        displayContent = ((String)displayContent).substring(0, 2000) + "\n... (\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e)";
                    }
                    this.resultText.setText((String)(displayContent != null ? displayContent : ""));
                    this.updateStatusLabel();
                }
            });
        }
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public String getToolName() {
        return this.toolName;
    }

    public MessagePart.ToolCallPart.ToolCallStatus getStatus() {
        return this.status;
    }

    public void dispose() {
        super.dispose();
    }
}

